<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;

/**
 * This is the model class for table "order_item".
 *
 * @property int $id
 * @property int|null $order_id
 * @property int|null $product_id
 * @property string|null $default_title
 * @property string|null $real_title
 * @property string|null $default_weight
 * @property string|null $real_weight
 * @property string|null $real_price
 * @property int|null $quantity
 * @property string|null $initial_total
 * @property string|null $real_total
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class OrderItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'order_item';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_id', 'product_id', 'quantity'], 'integer'],
            [['default_title', 'real_title','default_weight', 'real_weight', 'real_price', 'initial_total', 'real_total', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_id' => 'Order ID',
            'product_id' => 'Product ID',
            'default_title' => 'Default Title',
            'real_title' => 'Real Title',
            'default_weight' => 'Default Weight',
            'real_weight' => 'Real Weight',
            'real_price' => 'Real Price',
            'quantity' => 'Quantity',
            'initial_total' => 'Initial Total',
            'real_total' => 'Real Total',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }


    public function loadOrderItemByItemId($itemId){
        
        //controllo in order_item se ci sono record con order_id, product_id
        $ordersItem =  OrderItem::find()
            ->select('*')
            ->where("item_id = '".$itemId."'")
            ->one();

        return $ordersItem;

    }

    public function loadOrderItem($orderItemId){
        
        //controllo in order_item se ci sono record con order_id, product_id
        $orderItem =  OrderItem::find()
            ->select('*')
            ->where("id = '".$orderItemId."'")
            ->one();

        return $orderItem;

    }

    public function loadOrdersPending(){
        
        //controllo in order_item se ci sono record con order_id, product_id
        $ordersItem =  OrderItem::find()
                        ->select('*')
                        ->where("status = 'pending'")
                        ->orderBy('order_id')
                        ->all();

        return $ordersItem;

    }

    public function checkWeight($orderItem){

        if(!empty($orderItem)){
            $weight = $orderItem->real_weight;
        }else{
            $weight = "";
        }

        return $weight;
    }

    public function checkQuantity($orderItem){
        
        if(!empty($orderItem)){
            $quantity = $orderItem->quantity;
        }else{
            $quantity = "";
        }

        return $quantity;
    }
}
