<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcClient;
use emberware\vendia\arrivi\common\models\WcProduct;

class WcOrder extends WcClient
{
    /**
     * Lista di tutti gli ordini
     */
    public function findAllOrders(){
        return $this->get('orders');
    }

    /**
     * Singlo ordine
     */
    public function findOrder($id){
        return $this->get('orders/'.$id);
    }

    /**
     * Modifica ordine
     */
    public function updateOrder($id,$data){
        return $this->put('orders/'.$id, $data);
    }

    /**
     * Lista degli ordini in lavorazione
     */
    public function findPendingOrders(){
        return $this->get('orders?status='.Yii::$app->params['order-status']);
    }

    /**
     * Lista degli ordini in lavorazione contenenti prodotto con peso variabile ricercato
     */
    public function findOrdersWithProductVariableWeight($product){
     
        $orderItems = array();
        $arrOrder = array();
        $arrProduct = array();
        $pendingOrders = $this->findPendingOrders();

        foreach($pendingOrders as $order){
            $orderItems = $order->line_items;
            foreach($orderItems as $orderItem){
 
                if($orderItem->product_id == $product){

                    $wcProduct = new WcProduct();
                    $productCurrent = $wcProduct->findProduct($product);
                   
                    $metaDatas = $productCurrent->meta_data;

                    foreach($metaDatas as $metaData){
                        if($metaData->key == "unita_misura" && $metaData->value == "gr"){   
                            if(!in_array($order, $arrOrder, true)){
                                array_push($arrOrder, $order);
                            }    
                        }
                    }
                }
            }
           
        }
        return $arrOrder;

    }

    /**
     * Lista degli ordini in lavorazione contenenti prodotto con peso variabile ricercato
     */
    public function findOrdersMissingProduct($product){
       
        $orderItems = array();
        $arrProduct = array();
        $arrOrder = array();
        $pendingOrders = $this->findPendingOrders();

        foreach($pendingOrders as $order){
            $orderItems = $order->line_items;
            foreach($orderItems as $orderItem){
 
                if($orderItem->product_id == $product){
                    if(!in_array($order, $arrOrder, true)){
                        array_push($arrOrder, $order);
                    }  
                }
            }
        }
        return $arrOrder;
    }



}