<?php

namespace emberware\vendia\arrivi\backend\controllers;

use Yii;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\WcProduct;
use emberware\vendia\arrivi\common\models\OrderItem;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;

/**
 * OrderItemController implements the CRUD actions for OrderItem model.
 */
class OrderItemController extends Controller
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Search product
     * @return mixed
     */
    public function actionSearchProduct()
    {
        $wcProduct = new WcProduct();

        $request = Yii::$app->request;
        $search_key = $request->get('search'); 

        $wcProduct = new WcProduct();
        if($search_key){
            $listProduct = $wcProduct ->findSearchedProducts($search_key);
        }else{
            $listProduct = "";
        }       

        return $this->render('search-product', [
            'listProduct' => $listProduct,
            'search' => $search_key,
        ]);
    }

     /**
     * Load product witch variable weight
     * @return mixed
     */
    public function actionVariableWeight($product)
    {
        $wcProduct = new WcProduct();
        $prod = $wcProduct->findProduct($product);
       
        $metaDatas = $prod->meta_data;
        foreach($metaDatas as $metaData){
            if($metaData->key == "unita_vendita"){
                $productWeight = $metaData->value;
                $temp =  explode(" ", $productWeight);
                $productWeight = $temp[0];
            }
        }
        $price = $prod->price;

        $wcOrder = new WcOrder();
        $listOrders = $wcOrder->findOrdersWithProductVariableWeight($product);
        
        return $this->render('variable-weight', [
            'product' => $prod,
            'listOrder' => $listOrders,
            'productWeight' => $productWeight,
            'price' => $price,
        ]);
    }

     /**
     * Load product witch variable weight
     * @return mixed
     */
    public function actionMissingProduct($product)
    {
        $quantity = "";
        $wcProduct = new WcProduct();
        $prod = $wcProduct->findProduct($product);
        $metaDatas = $prod->meta_data;
        foreach($metaDatas as $metaData){
            if($metaData->key == "unita_vendita"){
                $productWeight = $metaData->value;
            }
        }
        $price = $prod->price;

        $wcOrder = new WcOrder();
        $listOrders = $wcOrder->findOrdersMissingProduct($product);

        return $this->render('missing-product', [
            'product' => $prod,
            'listOrder' => $listOrders,
            'productWeight' => $productWeight,
            'price' => $price,
        ]);
    }


    /**
     * Search product
     * @return mixed
     */
    public function actionUpdateOrderVariable()
    {
        $result = false;
        $orderItem = new OrderItem();
        $wcProduct = new WcProduct;
        $wcOrder = new WcOrder;

        $request = Yii::$app->request->post();
        $postProduct = $request['Order'];
      

        foreach($postProduct as $product){

            if($product['product-weight'] != $product['product-new-weight']){

                 //controllo in order_item se ci sono record con item_id
                $orderItem = $orderItem->loadOrderItemByItemId($product['item-id']);

                if(empty($orderItem)){   
                    $orderItem = new OrderItem(); 
                    $orderItem->item_id = $product['item-id'];
                    $orderItem->order_id = $product['order-id'];
                    $orderItem->product_id = $product['product-id'];
                    $orderItem->default_title = $product['product-title'];
                    $orderItem->default_weight = $product['product-weight'];
                    $orderItem->initial_total = $product['product-total'];   
                    $orderItem->status = "pending";
                    $orderItem->created_at = time();
                }     
               
                $orderItem->real_title = $product['product-title']." - Peso reale: ".$product['product-new-weight']. " gr";

                $orderItem->real_weight = $product['product-new-weight'];
                $realPrice = $wcProduct->newPrice($product['product-price'], $product['product-weight'], $product['product-new-weight']);

                $orderItem->quantity =  $product['product-quantity'];

                $orderItem->real_price = $realPrice;                     
                $orderItem->real_total = $wcProduct->quantityPrice($realPrice, $orderItem->quantity);
                $orderItem->status = "pending";

                $orderItem->updated_at = time();
                $result = $orderItem->save(false);
               
            }else{
                $result = true;
            }
        }

        if($result){
            $result = true;
        }else {
            $result = false;
        }

        return $this->render('confirm-order', [
            'result' => $result
        ]);
      
    }


    /**
     * Search product
     * @return mixed
     */
    public function actionUpdateOrderMissing()
    {
        $result = false;
        $orderItem = new OrderItem();
        $wcProduct = new WcProduct;
        $wcOrder = new WcOrder;
        
        $request = Yii::$app->request->post();
        $postProduct = $request['Order'];

        foreach($postProduct as $product){

            if($product['product-quantity'] != $product['product-new-quantity']){
               
                //controllo in order_item se ci sono record con order_id, product_id
                $orderItem = $orderItem->loadOrderItemByItemId($product['item-id']);

                if(empty($orderItem)){   
                    $orderItem = new OrderItem(); 
                    $orderItem->order_id = $product['order-id'];
                    $orderItem->product_id = $product['product-id'];
                    $orderItem->default_title = $product['product-title'];
                    $orderItem->real_title = $product['product-title'];
                    $orderItem->default_weight = $product['product-weight'];
                    $orderItem->initial_total = $product['product-total']; 
                    $orderItem->status = "pending";
                    $orderItem->created_at = time();
                }

                $orderItem->quantity = $product['product-new-quantity'];

                $orderItem->real_price = $product['product-price'];               
                
                //controllo peso
                $weight = $orderItem->checkWeight($orderItem);
                if($weight != ""){
                    $orderItem->real_weight = $weight;
                }else{
                    $orderItem->real_weight = $product['product-weight'];
                }
                    
                $orderItem->real_total = $wcProduct->quantityPrice($product['product-price'], $product['product-new-quantity']);
                $orderItem->updated_at = time();
                $orderItem->status = "pending";

                $result = $orderItem->save(false);
            }else{
                $result = true;
            }
        }

        if($result){
            $result = true;
        }else {
            $result = false;
        }

        return $this->render('confirm-order', [
            'result' => $result
        ]);
       
      
    }

    public function actionSendWoocommerce(){
        $result = false;
        $resultStatus = false;
        $totalOrder = 0;
        $wcOrder = new WcOrder();
        $orderItem = new OrderItem();

        $listOrdersItem = $orderItem->loadOrdersPending();
       
        foreach($listOrdersItem as $item){
            $order = $wcOrder->findOrder($item->order_id);
            foreach($order->line_items as $line_item){
                if($item->item_id == $line_item->id){
                    $array_put = [
                        "line_items" => 
                        [
                            [
                                "id" => "".$line_item->id."",
                                "quantity" => "".$item->quantity."",
                                "name" => "".$item->real_title."",
                                "total" => "".$item->real_total."",
                                "subtotal" => "".$item->real_total.""
                            ]
                        ]
                    ];
                    
                    $result = $wcOrder->updateOrder($item->order_id, $array_put);   
                }
            }
            if($result){
                $orderItemStatus = OrderItem::findOne($item->id);

                $orderItemStatus->status = "sent";
                $resultStatus = $orderItemStatus->save(false);
            }  
        }

        return $this->render('confirm-send', [
            'result' => $resultStatus
        ]);
       
    }

    /**
     * Finds the House model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return House the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = OrderItem::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


}