$( document ).ready(function() {

    var totWeight = 0;
    var totPieces = 0;
    var totEquivalentPieces = 0;
    var totWeightReal = 0;

    $("#show-variable").click(function(){
        $(".normal").hide();
    });
    $("#show-all").click(function(){
        $(".normal").show();
    });

    $(".variable-weight").each(function(){
        totWeightReal = totWeightReal + parseInt($(this).val());
    });
    $('#total-weight').html(totWeightReal);
    
    $(".variable-pieces").each(function(){
        totPieces = totPieces + parseInt($(this).val());
    });
    $('#total-pieces').html(totPieces);

    var totWeight = $(".tot-weight").val();

    totEquivalentPieces = totWeightReal / totWeight;
    $('#total-equivalent-pieces').html(roundTo(totEquivalentPieces, 2));

    //on change
    $(".variable-weight").on("change paste keyup", function() {
        $('#total-weight').html(updateWeight());
        var totWeightReal = updateWeight();
        $('#total-equivalent-pieces').html(updateEquivalentPieces(totWeightReal));
    });
    $(".variable-pieces").on("change paste keyup", function() {
        $('#total-pieces').html(updatePieces());
    });

});

function updateWeight(){
    var totWeight = 0;
    $(".variable-weight").each(function(){
        totWeight = totWeight + parseInt($(this).val());
    });
    return totWeight;
}

function updateEquivalentPieces(totWeightReal){
    var totEquivalentPieces = 0;
    var totWeight = $(".tot-weight").val();
    
    totEquivalentPieces = roundTo(totWeightReal / totWeight, 2);
    return totEquivalentPieces;
}

function updatePieces(){
    var totPieces = 0;
    $(".variable-pieces").each(function(){
        totPieces = totPieces + parseInt($(this).val());
    });
    return totPieces;
}

function roundTo(value, places){
    var power = Math.pow(10, places);
    return Math.round(value * power) / power;
}