<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcClient;

class WcProduct extends WcClient
{

    /**
     * Lista di tutti i prodotti
    */
    public function findAllProducts(){
        return $this->get('products?per_page=100&page=1&orderby=title&order=asc&search=Zuc');
    }

    /**
     * Lista dei prodotto dopo la ricerca
    */
    public function findSearchedProducts($search){
        return $this->get('products?per_page=100&orderby=title&order=asc&search='.urlencode($search));
    }

    /**
     * Lista di tutti i prodotti
    */
    public function findProduct($id){
        return $this->get('products/'.$id);
    }


    public function getQuantity($order,$idProduct){

        $quantity = 0;
        $line_items = $order->line_items;

        foreach($line_items as $item){
            
            if($item->product_id == $idProduct){
                $quantity = $item->quantity;
            }
        }

        return $quantity;
    }

    public function getTotal($order, $idProduct){
        $total = 0;
        $line_items = $order->line_items;

        foreach($line_items as $item){
            if($item->product_id == $idProduct){
                $total = $item->total;
            }
        }

        return $total;
    }

    public function newPrice($price, $weight, $newWeight){
        
        $newPrice = ($price / $weight) * $newWeight;
        return number_format($newPrice, 2, '.', '');
    }

    public function quantityPrice($price, $quantity){
        
        $quantityPrice = $price * $quantity;
        return number_format($quantityPrice, 2, '.', '');
    }


}
