<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcClient;

class WcProduct extends WcClient
{

    /**
     * Lista di tutti i prodotti
    */
    public function findProducts($page){
        return $this->get('products?per_page=100&page='.$page.'&orderby=title&order=asc');
    }

    /**
     * Lista dei prodotto dopo la ricerca
    */
    public function findSearchedProducts($search){
        return $this->get('products?per_page=100&orderby=title&order=asc&search='.urlencode($search));
    }

    /**
     * Lista di tutti i prodotti
    */
    public function findProduct($id){
        return $this->get('products/'.$id);
    }

    public function findAllProducts(){

        $page = 1;
        $arrProducts = array();

        $products = $this->findProducts($page);

        while(!empty($products)){
            foreach($products as $product){
                array_push($arrProducts, $product);
            }
            $page++;   
            $products = $this->findProducts($page);        
        }

        return $arrProducts;
    }


    public function getQuantity($order,$idProduct){

        $quantity = 0;
        $line_items = $order->line_items;

        foreach($line_items as $item){
            
            if($item->product_id == $idProduct){
                $quantity = $item->quantity;
            }
        }

        return $quantity;
    }

    public function getTotal($order, $idProduct){
        $total = 0;
        $line_items = $order->line_items;

        foreach($line_items as $item){
            if($item->product_id == $idProduct){
                $total = $item->total;
            }
        }

        return $total;
    }

    public function newPrice($price, $weight, $newWeight, $quantity){
        
        if($quantity != "0"){
            $newPrice = (($price / $weight) * $newWeight) / $quantity;
            return number_format($newPrice, 2, '.', '');
        }else{
            return "0";
        }
        
    }

    public function quantityPrice($price, $quantity){
        if($quantity != "0"){
            $quantityPrice = $price * $quantity;
            return number_format($quantityPrice, 2, '.', '');
        }else{
            return "0";
        }
       
    }


}
