<?php
namespace emberware\vendia\arrivi\common\behaviors;

use yii\base\Behavior;

class StatusBehaviors extends Behavior
{
    private $status;

    public function getStatus(){
        return $this->status;
    }

    /**
     * Aggiornamento dei sync_status
     */
    public function setStatus($newStatus){

        if(!($newStatus == "completed" || $newStatus == "processing" || $newStatus == "in_progress" || $newStatus == "on-hold" )){
            return;
        }

        if($this->status == "completed"){
            return;
        }

        $this->owner->status = $newStatus;
    }

    public function statusActiveQuery($status){        
        $class = get_class($this);
        return $this->owner::find()->where(["status" => $status]);
    }

    public function findStatusAll($status){
        return $this->statusActiveQuery($status)->all();
    }
}