<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcClient;
use emberware\vendia\arrivi\common\models\WcProduct;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\groups\common\models\GroupOrder;

class WcOrder extends WcClient
{
    /**
     * Lista di tutti gli ordini
     */
    public function findAllOrders(){
        return $this->get('orders');
    }

    /**
     * Singlo ordine
     */
    public function findOrder($id){
        return $this->get('orders/'.$id);
    }

    /**
     * Crea ordine
     */
    public function createOrder($data){
        return $this->post('orders', $data);
    }

    /**
     * cancella ordine
     */
    public function deleteOrder($id){
        return $this->delete('orders/'.$id);
    }

    /**
     * Modifica ordine
     */
    public function updateOrder($id,$data){
        return $this->put('orders/'.$id, $data);
    }

    /**
     * Lista degli ordini in lavorazione
     */
    public function findPendingOrders($page){
        return $this->get('orders?per_page=100&page='.$page.'&status='.Yii::$app->params['order-status']);
    }

    /**
     * Lista degli ordini in processing
     */
    public function findProcessingOrders($page){
        return $this->get('orders?page='.$page.'&status=on-hold,processing');
    }

    /**
     * Lista degli ordini in processing
     */
    public function findProcessingOrdersByDate($dataOrder, $per_page){
        return $this->get('orders?status=processing&per_page='.$per_page.'&orderby=date&order=asc&after=' .$dataOrder);
    }

    /**
     * Function: findAll()
     * params: array()
     */
    public function findAll($params){
        return $this->get('orders?'.http_build_query($params));
    }


    public function findOrdersCustomers(){

        $page = 1;
        $arrOrdersCustomers = array();

        $ordersProcessing = $this->findProcessingOrders($page);

        while(!empty($ordersProcessing)){
            foreach($ordersProcessing as $orderProcessing){
                array_push($arrOrdersCustomers, $orderProcessing);
            }
            $page++;
            $ordersProcessing = $this->findProcessingOrders($page);
        }

        return $arrOrdersCustomers;
    }

    /**
     * Se pagina 1 ho elementi ok
     * Se pagina 1 non ho elementi controllo che pagina 2 abbia elementi e se li ha controllo che siano con la data successiva se no aumento
     */


    // public function findOrdersCustomersByDate($data_order, $per_page){

    //     $page = 1;
    //    // $nextPage = $page + 1;
    //     $arrOrdersCustomers = array();

    //     $checkOrders = $this->findProcessingOrders($page, $per_page);

    //     if(!empty($checkOrders)){
    //         while(!empty($checkOrders)){
    //             $ordersProcessing = $this->findProcessingOrdersByDate($data_order, $per_page, $page);
    //             $page++;
    //             if(!empty($ordersProcessing)){
    //                 foreach($ordersProcessing as $orderProcessing){
    //                     array_push($arrOrdersCustomers, $orderProcessing);
    //                 }
    //                 break;
    //             }else{
    //                 $checkOrders = $this->findProcessingOrders($page, $per_page);
    //             }
    //         }
    //     }

    //     return $arrOrdersCustomers;
    // }

    /**
     * Lista degli ordini in lavorazione contenenti prodotto con peso variabile ricercato
     */
    public function findOrdersWithProductVariableWeight($product){

        $orderItems = array();
        $arrOrder = array();
        $arrProduct = array();
        $page = 1;

        $pendingOrders = $this->findPendingOrders($page);

        while(!empty($pendingOrders)){
            foreach($pendingOrders as $order){
                $lineItems = $order->line_items;
                foreach($lineItems as $lineItem){

                    if($lineItem->product_id == $product){

                        $wcProduct = new WcProduct();
                        $productCurrent = $wcProduct->findProduct($product);

                        $metaDatas = $productCurrent->meta_data;

                        foreach($metaDatas as $metaData){
                            if($metaData->key == "unita_misura" && $metaData->value == "gr"){
                                if(!in_array($order, $arrOrder, true)){
                                    array_push($arrOrder, $order);
                                }
                            }
                        }
                    }
                }
            }
            $page++;
            $pendingOrders = $this->findPendingOrders($page);
        }


        return $arrOrder;

    }

    /**
     * Lista degli ordini in lavorazione contenenti prodotto con peso variabile ricercato
     */
    public function findOrdersMissingProduct($product){

        $orderItems = array();
        $arrProduct = array();
        $arrOrder = array();
        $page = 1;

        $pendingOrders = $this->findPendingOrders($page);

        while(!empty($pendingOrders)){
            foreach($pendingOrders as $order){
                $orderItems = $order->line_items;
                foreach($orderItems as $orderItem){

                    if($orderItem->product_id == $product){
                        if(!in_array($order, $arrOrder, true)){
                            array_push($arrOrder, $order);
                        }
                    }
                }
            }
            $page++;
            $pendingOrders = $this->findPendingOrders($page);
        }
        return $arrOrder;
    }



    /**
     * Lista degli ordini in processing di tutti i customer di un group
     */
    public function findOrdersAllCustomer(){

        $arrGroup = array();
        $groups = Group::find()->all();
        $i = 0;

        foreach($groups as $group){
            $customers = $group->customers_id;
            $arrCustomers = explode(',', $customers);

            foreach($arrCustomers as $customer){
                $ordersCustomer = $this->findOrdersCustomers($customer);

                foreach($ordersCustomer as $orderCustomer){
                    $arrGroup[$i][$customer] =  $orderCustomer->line_items;
                }
            }
            $i++;
        }

        return $arrGroup;
    }

     /**
     * Lista degli ordini in processing di tutti i customer di un group
     */
    public function findOrdersSingleGroupCustomer($id){

        $arrGroup = array();
        $group = Group::find()
                        ->select('*')
                        ->where("id = '".$id."'")
                        ->one();

        $customers = $group->customers_id;
        $arrCustomers = explode(',', $customers);

        foreach($arrCustomers as $customer){
            $ordersCustomer = $this->findOrdersCustomers($customer);

            foreach($ordersCustomer as $orderCustomer){
                $arrGroup[$customer] =  $orderCustomer->line_items;
            }
        }

        return $arrGroup;
    }

    /**
     * Lista degli ordini in processing di tutti i customer di un group
     */
    public function findOrdersGroups(){

        $arrGroup = array();
        $arrCustomer = array();
        $groups = Group::find()->all();
        $i = 0;

        foreach($groups as $group){

            $customers = $group->customers_id;
            $arrCustomers = explode(',', $customers);
            $arrCustomer = array();
            foreach($arrCustomers as $customer){

                $ordersCustomer = $this->findOrdersCustomers($customer);

                foreach($ordersCustomer as $orderCustomer){
                    $arrCustomer = array_merge($arrCustomer, $orderCustomer->line_items);
                }
            }
            array_push($arrGroup,$arrCustomer);
            $i++;
        }

        return $arrGroup;
    }



}