<?php
namespace emberware\vendia\arrivi\common\behaviors;

use yii\base\Behavior;

class SyncStatusBehaviors extends Behavior
{

    private $status;
    public $sync_status;

    public function getSyncStatus(){
        return $this->sync_status;
    }

    /**
     * Aggiornamento dei sync_status
     */
    public function setSyncStatus($newSyncStatus){

        if(!($newSyncStatus == "to_create" || $newSyncStatus == "to_update" || $newSyncStatus == "synced")){
            return;
        }

        if($this->owner->sync_status == "to_create" && $newSyncStatus == "to_update"){
            return;
        }

        $this->owner->sync_status = $newSyncStatus;
    }

    public function syncCreatedPendingActiveQuery(){
        $class = get_class($this);
        return $this->owner::find()->where(["sync_status" => "to_create"]);
    }

    public function findSyncCreatePendingAll(){
        return $this->syncCreatedPendingActiveQuery()->all();
    }

    public function syncUpdatePendingActiveQuery(){
        $class = get_class($this);
        return $this->owner::find()->where(["sync_status" => "to_update"]);
    }

    public function findSyncUpdatePendingAll(){
        return $this->syncUpdatePendingActiveQuery()->all();
    }

    public function getNumberOfUpdatePending(){
        return $this->syncUpdatePendingActiveQuery()->count();
    }

    public function getNumberOfCreatePending(){
        return $this->syncCreatedPendingActiveQuery()->count();
    }
}