<?php
use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use fedemotta\datatables\DataTables;
use emberware\vendia\arrivi\backend\Asset;
use emberware\vendia\arrivi\common\models\WcCustomer;
use emberware\vendia\arrivi\common\models\WcProduct;
use emberware\vendia\arrivi\common\models\OrderItem;

emberware\vendia\arrivi\backend\Asset::register($this);
/* @var $this yii\web\View */
/* @var $searchModel backend\models\GuestSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
?>
<button class="print btn btn-primary action-button" onclick="window.print()"><i class="fa fa-print"></i> Stampa</button>
<div class="orderitem-list">
    <h1 class="title-page">Modifica prodotti mancanti</h1>
    <h3 class="subtitle-page"><?=$product->name?></h3>
    <hr class="hr-class">
    <?php
    if($listOrder){
    ?>
    <form action="update-order-missing" method="post">
        <ul class="list-group">
            <div class="row">
            
                <?php 
                    $i = 0;
                    foreach($listOrder as $order){
                       
                        $wcCustomer = new WcCustomer();
                        $customer = $wcCustomer->findCustomer($order->customer_id);

                        $wcProduct = new WcProduct(); 
                        $productTotal = $wcProduct->getTotal($order, $product->id);

                ?>
                <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">                            
                    <div class="box-product">                        
                        <?php foreach($order->line_items as $line_item){ 
                            if($product->id == $line_item->product_id){
                                $quantity = $line_item->quantity;

                                $orderItem = new OrderItem();
                                $orderItem = $orderItem->loadOrderItemByItemId($line_item->id);
                            
                                if(empty($orderItem)){ 
                                    $newQuantity = $quantity;  
                                }else{
                                    $newQuantity = $orderItem->quantity;
                                }
                        ?>
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4"> 
                                <div class="box-title-input">         
                                    <h5 class="order"><?="Ordine n. ".$order->number." di <br>".$customer->first_name." ".$customer->last_name?> </h5>
                                </div>
                            </div>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">   
                                <div class="box-input-quantity">                                 
                                    <b class="title-label">Quantità:</b><input class="form-control form-input-quantity variable-pieces" value="<?=$newQuantity?>" type="text" name="Order[<?=$i?>][product-new-quantity]">                        
                                </div>
                            </div>
                        </div>
                        <input value="<?=$order->id?>" type="hidden" name="Order[<?=$i?>][order-id]">
                        <input value="<?=$product->id?>" type="hidden" name="Order[<?=$i?>][product-id]">
                        <input value="<?=$line_item->id?>" type="hidden" name="Order[<?=$i?>][item-id]">
                        <input value="<?=$product->name?>" type="hidden" name="Order[<?=$i?>][product-title]">
                        <input value="<?=$price?>" type="hidden" name="Order[<?=$i?>][product-price]">
                        <input value="<?=$productTotal?>" type="hidden" name="Order[<?=$i?>][product-total]">
                        <input value="<?=$productWeight?>" class="variable-weight" type="hidden" name="Order[<?=$i?>][product-weight]">
                        <input value="<?=$quantity?>" type="hidden" name="Order[<?=$i?>][product-quantity]">
                        <?php   
                            $i++;
                            }
                        }
                        ?>
                    </div>
                </div>
            <?php    
                }                
            ?>
            </div>
        </ul>
        <!-- <div class="weight"><b>Totale peso:</b> <div id="total-weight"></div> gr</div><br><br> -->
        <div class="pieces"><b>Totale pezzi:</b> <div id="total-pieces"></div> pz</div><br><br>
        <input type="submit" value="Conferma modifiche" class='btn btn-success'>
    </form>
    <?php }else{
        echo "Non ci sono ordini contenenti questo prodotto!";
    } 
    ?>
    <br>
    <a class="back" href="search-product">Torna alla ricerca</a>
</div>

