<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\arrivi\common\behaviors\SyncStatusBehaviors;

/**
 * This is the model class for table "order_item".
 *
 * @property int $id
 * @property int|null $order_id
 * @property int|null $product_id
 * @property string|null $default_title
 * @property string|null $real_title
 * @property string|null $default_weight
 * @property string|null $real_weight
 * @property string|null $real_price
 * @property int|null $quantity
 * @property string|null $initial_total
 * @property string|null $real_total
 * @property string|null $sync_status
 * @property string|null $created_at
 * @property string|null $updated_at
 *
 * @property Order[] $order
 */
class OrderItem extends \yii\db\ActiveRecord
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'sync_status' => [
                'class' => SyncStatusBehaviors::className(),
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'order_item';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_id', 'product_id', 'quantity'], 'integer'],
            [['default_title', 'real_title','default_weight', 'real_weight', 'real_price', 'initial_total', 'real_total', 'sync_status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_id' => 'Order ID',
            'product_id' => 'Product ID',
            'default_title' => 'Default Title',
            'real_title' => 'Real Title',
            'default_weight' => 'Default Weight',
            'real_weight' => 'Real Weight',
            'real_price' => 'Real Price',
            'quantity' => 'Quantity',
            'initial_total' => 'Initial Total',
            'real_total' => 'Real Total',
            'sync_status' => 'sync status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }


    public function loadOrderItemByItemId($itemId){

        //controllo in order_item se ci sono record con order_id, product_id
        $ordersItem =  OrderItem::find()
                                ->select('*')
                                ->where("item_id = '".$itemId."'")
                                ->one();

        return $ordersItem;

    }

    public function loadOrderItemByStatus($itemId){

        //controllo in order_item se ci sono record con order_id, product_id
        $ordersItem =  OrderItem::find()
                                ->select('*')
                                ->where("item_id = '".$itemId."' AND status = 'to_send_group'")
                                ->one();

        return $ordersItem;

    }

    public function loadGroupOrderItems(){

        $ordersItem =  OrderItem::find()
                            ->select('*')
                            ->where("status = 'to_send_group'")
                            ->all();

        return $ordersItem;
    }

    public function findSyncUpdatePendingAll(){
        return  $this->syncUpdatePendingActiveQuery()
                     ->orderBy('order_id')
                     ->all();
    }

    public function checkWeight($orderItem){

        if(!empty($orderItem)){
            $weight = $orderItem->real_weight;
        }else{
            $weight = "";
        }

        return $weight;
    }

    public function checkQuantity($orderItem){

        if(!empty($orderItem)){
            $quantity = $orderItem->quantity;
        }else{
            $quantity = "";
        }

        return $quantity;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrder()
    {
        return $this->hasOne(Order::className(), ['order_wc_id' => 'order_id']);
    }

    public function updatePendingWcOrders(){
        $result = false;
        $resultStatus = false;
        // $totalOrder = 0;
        $wcOrder = new WcOrder();
        // $orderItem = new OrderItem();

        $listOrdersItem = $this->findSyncUpdatePendingAll();

        foreach($listOrdersItem as $item){
            $order = $wcOrder->findOrder($item->order_id);
            foreach($order->line_items as $line_item){
                if($item->item_id == $line_item->id){
                    $array_put = [
                        "line_items" =>
                        [
                            [
                                "id" => "".$line_item->id."",
                                "quantity" => "".$item->quantity."",
                                "name" => "".$item->real_title."",
                                "total" => "".$item->real_total."",
                                "subtotal" => "".$item->real_total.""
                            ]
                        ]
                    ];

                    $result = $wcOrder->updateOrder($item->order_id, $array_put);
                }
            }
            if($result){
                // $orderItem = OrderItem::findOne($item->id);
                $item->setSyncStatus("synced");
                $resultStatus = $item->save(false);
            }
        }
        return $result;

    }

    public function updateSyncStatus($sync_status){
        $this->setSyncStatus($sync_status);
        if($sync_status == 'to_update' && $this->order && $this->order->groupOrder){
            $groupOrder = $this->order->groupOrder;
            $groupOrder->setSyncStatus($sync_status);
            $result = $groupOrder->save(false);
        }
    }
}
