$( document ).ready(function() {

    var totWeight = 0;
    var totPieces = 0;
    var totEquivalentPieces = 0;
    var totWeightReal = 0;

    $("#show-variable").click(function(){
        $(".normal").hide();
    });
    $("#show-all").click(function(){
        $(".normal").show();
    });

    $(".variable-weight").each(function(){
        totWeightReal = totWeightReal + parseInt($(this).val());
    });
    $('#total-weight').html(totWeightReal);
    
   
    var totWeight = $(".tot-weight").val();

    $(".variable-pieces").each(function(){
        totPieces = totPieces + parseInt($(this).val());
        var id = $(this).attr("id");
        var pieces = $(this).val();
        var variableWeight = $("#row-"+id+" .variable-weight").val();
        
        if($(this).val() == "0" || $(this).val() == ""){
            $("#row-"+id+" .variable-weight").attr('readonly','readonly');
            $("#row-"+id+" .variable-weight").val("0");
        }else{
            $("#row-"+id+" .variable-weight").removeAttr('readonly');
            $("#row-"+id+" .variable-weight").val(variableWeight);
        }
    });
    $('#total-pieces').html(totPieces);


    totEquivalentPieces = totWeightReal / totWeight;
    $('#total-equivalent-pieces').html(roundTo(totEquivalentPieces, 2));

    var totWeightReal = updateWeight();
    var totPieces = updatePieces();
    var totEquivalentPieces = updateEquivalentPieces(totWeightReal);
    
    var discount = calculateDiscount(totWeight, totWeightReal, totPieces);
    $('#total-discount').html(discount);

    //on change
    $(".variable-weight").on("change paste keyup", function() {
        $('#total-weight').html(updateWeight());
        var totWeightReal = updateWeight();
        $('#total-equivalent-pieces').html(updateEquivalentPieces(totWeightReal));
    });

    $(".variable-pieces").on("change paste", function() {
        
        $('#total-pieces').html(updatePieces());
        var id = $(this).attr("id");
        var pieces = $(this).val();
        var realWeight = $("#row-"+id+" .real-weight").val();

        if($(this).val() == "0" || $(this).val() == ""){
            $("#row-"+id+" .variable-weight").attr('readonly','readonly');
            $("#row-"+id+" .variable-weight").val("0");
        }else{
            $("#row-"+id+" .variable-weight").removeAttr('readonly');
            $("#row-"+id+" .variable-weight").val(realWeight*pieces);
        }
        var totWeightReal = updateWeight();
        $('#total-equivalent-pieces').html(updateEquivalentPieces(totWeightReal));
        var totPieces = updatePieces();
        var totEquivalentPieces = updateEquivalentPieces(totWeightReal);
        var discount = calculateDiscount(totWeight, totWeightReal, totPieces);
        $('#total-discount').html(discount);
        $('#total-weight').html(updateWeight());
        
    });

    $(".variable-weight").on("change paste keyup", function() {
        $('#total-weight').html(updateWeight());
        var totWeightReal = updateWeight();
        $('#total-equivalent-pieces').html();
        var totPieces = updatePieces();
        var totEquivalentPieces = updateEquivalentPieces(totWeightReal);
        var discount = calculateDiscount(totWeight, totWeightReal, totPieces);
        $('#total-discount').html(discount);
    });

    //page discount calculator
    $(".single-weight").on("change paste keyup", function() {
        var singleWeight = $(this).val();
        var totalWeight = $(".total-weight").val();
        var numberPieces = $(".number-pieces").val();
        var discount = calculateDiscount(singleWeight, totalWeight, numberPieces);
        $('.discount').html(discount+"%");
    });

    $(".total-weight").on("change paste keyup", function() {
        var singleWeight = $(".single-weight").val();
        var totalWeight = $(this).val();
        var numberPieces = $(".number-pieces").val();
        var discount = calculateDiscount(singleWeight, totalWeight, numberPieces);
        $('.discount').html(discount+"%");
    });

    $(".number-pieces").on("change paste keyup", function() {
        var singleWeight = $(".single-weight").val();
        var totalWeight = $(".total-weight").val();
        var numberPieces = $(this).val();
        var discount = calculateDiscount(singleWeight, totalWeight, numberPieces);
        $('.discount').html(discount+"%");
    });

});

function updateWeight(){    
    var totWeight = 0;
    $(".variable-weight").each(function(){
        totWeight = totWeight + parseInt($(this).val());
    });
    return totWeight;
}

function updateEquivalentPieces(totWeightReal){
    var totEquivalentPieces = 0;
    var totWeight = $(".tot-weight").val();
    
    totEquivalentPieces = roundTo(totWeightReal / totWeight, 2);
    return totEquivalentPieces;
}

function updatePieces(){
    var totPieces = 0;
    $(".variable-pieces").each(function(){
        totPieces = totPieces + parseInt($(this).val());
    });
    return totPieces;
}

function roundTo(value, places){
    var power = Math.pow(10, places);
    return Math.round(value * power) / power;
}

function calculateEquivalentPrice(default_pieces,equivalent_pieces){
    var defaultPrice = $("#default_price").val();
    var equivalentPrice = defaultPrice/default_pieces*equivalent_pieces;
    var discount = ((defaultPrice-equivalentPrice)/defaultPrice)*100;
    return roundTo(discount, 2);
}

function calculateDiscount(originalWeight, totalWeightReal, numberPieces){
    var discount = ((numberPieces*originalWeight - totalWeightReal)/(numberPieces*originalWeight))*100;
    return roundTo(discount, 2);
}