<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\arrivi\common\behaviors\SyncStatusBehaviors;

/**
 * This is the model class for table "order_item".
 *
 * @property int $id
 * @property int|null $order_id
 * @property int|null $product_id
 * @property string|null $default_title
 * @property string|null $real_title
 * @property string|null $default_weight
 * @property string|null $real_weight
 * @property string|null $real_price
 * @property int|null $quantity
 * @property string|null $initial_total
 * @property string|null $real_total
 * @property string|null $sync_status
 * @property string|null $created_at
 * @property string|null $updated_at
 *
 * @property Order[] $order
 */
class OrderItem extends \yii\db\ActiveRecord
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'sync_status' => [
                'class' => SyncStatusBehaviors::className(),
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'order_item';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_id', 'product_id', 'quantity'], 'integer'],
            [['default_title', 'real_title','default_weight', 'real_weight', 'real_price', 'initial_total', 'real_total', 'sync_status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_id' => 'Order ID',
            'product_id' => 'Product ID',
            'default_title' => 'Default Title',
            'real_title' => 'Real Title',
            'default_weight' => 'Default Weight',
            'real_weight' => 'Real Weight',
            'real_price' => 'Real Price',
            'quantity' => 'Quantity',
            'initial_total' => 'Initial Total',
            'real_total' => 'Real Total',
            'sync_status' => 'sync status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrder()
    {
        return $this->hasOne(Order::className(), ['order_wc_id' => 'order_id']);
    }

    public static function loadOrderItemByItemId($itemId){
        $ordersItem =  OrderItem::find()
                                ->select('*')
                                ->where("item_id = '".$itemId."'")
                                ->one();
        return $ordersItem;
    }
    
    public function findSyncUpdatePendingAll(){
        return  $this->syncUpdatePendingActiveQuery()
                     ->orderBy('order_id')
                     ->all();
    }

    public static function checkWeight($orderItem){
        if(!empty($orderItem)){
            $weight = $orderItem->real_weight;
        }else{
            $weight = "";
        }
        return $weight;
    }    

    public function updatePendingWcOrders(){
        $result = false;
        $resultStatus = false;
        // $totalOrder = 0;
        $wcOrder = new WcOrder();
        // $orderItem = new OrderItem();

        $listOrdersItem = $this->findSyncUpdatePendingAll();

        foreach($listOrdersItem as $item){
            $order = $wcOrder->findOrder($item->order_id);
            foreach($order->line_items as $line_item){
                if($item->item_id == $line_item->id){
                    $array_put = [
                        "line_items" =>
                        [
                            [
                                "id" => "".$line_item->id."",
                                "quantity" => "".$item->quantity."",
                                "name" => "".$item->real_title."",
                                "total" => "".$item->real_total."",
                                "subtotal" => "".$item->real_total.""
                            ]
                        ]
                    ];

                    $result = $wcOrder->updateOrder($item->order_id, $array_put);
                }
            }
            if($result){
                // $orderItem = OrderItem::findOne($item->id);
                $item->setSyncStatus("synced");
                $resultStatus = $item->save(false);
            }
        }
        return $result;

    }

    public function updateSyncStatus($sync_status){
        $this->setSyncStatus($sync_status);
        if($sync_status == 'to_update' && $this->order && $this->order->groupOrder){
            $groupOrder = $this->order->groupOrder;
            $groupOrder->setSyncStatus($sync_status);
            $result = $groupOrder->save(false);
        }
    }

    public static function updateOrderItemVariableProduct($request){
        
        $postProduct = $request['Order'];

        foreach($postProduct as $product){

            if($product['product-weight'] != $product['product-new-weight']){

                 //controllo in order_item se ci sono record con item_id
                $orderItem = OrderItem::loadOrderItemByItemId($product['item-id']);

                if(empty($orderItem)){
                    $orderItem = new OrderItem();
                    $orderItem->item_id = $product['item-id'];
                    $orderItem->order_id = $product['order-id'];
                    $orderItem->product_id = $product['product-id'];
                    $orderItem->default_title = $product['product-title'];
                    $orderItem->default_weight = $product['product-weight'];
                    $orderItem->initial_total = $product['product-total'];
                    $orderItem->setSyncStatus("to_update");
                    $orderItem->created_at = time();
                }

                $orderItem->real_title = $product['product-title']." - Peso reale: ".$product['product-new-weight']. " gr";

                $orderItem->real_weight = $product['product-new-weight'];

                $orderItem->quantity =  $product['product-quantity'];
                $realPrice = WcProduct::newPrice($product['product-price'], $product['product-weight'], $product['product-new-weight'], $product['product-quantity']);

                $orderItem->real_price = $realPrice;
                $orderItem->real_total = WcProduct::quantityPrice($realPrice, $orderItem->quantity);
                $orderItem->updateSyncStatus("to_update");

                $orderItem->updated_at = time();
                $orderItem->save(false);
            }
        }
    }

    public static function updateOrderItemMissingProduct($request){
        $postProduct = $request['Order'];

        foreach($postProduct as $product){

            if($product['product-quantity'] != $product['product-new-quantity']){

                //controllo in order_item se ci sono record con order_id, product_id
                $orderItem = OrderItem::loadOrderItemByItemId($product['item-id']);

                if(empty($orderItem)){
                    $orderItem = new OrderItem();
                    $orderItem->item_id = $product['item-id'];
                    $orderItem->order_id = $product['order-id'];
                    $orderItem->product_id = $product['product-id'];
                    $orderItem->default_title = $product['product-title'];
                    $orderItem->real_title = $product['product-title'];
                    $orderItem->default_weight = $product['product-weight'];
                    $orderItem->initial_total = $product['product-total'];
                    $orderItem->setSyncStatus("to_update");
                    $orderItem->created_at = time();
                }

                $orderItem->quantity = $product['product-new-quantity'];

                $orderItem->real_price = $product['product-price'];

                //controllo peso
                $weight = OrderItem::checkWeight($orderItem);
                if($weight != ""){
                    $orderItem->real_weight = $weight;
                }else{
                    $orderItem->real_weight = $product['product-weight'];
                }

                $orderItem->real_total = WcProduct::quantityPrice($product['product-price'], $product['product-new-quantity']);
                $orderItem->updated_at = time();
                $orderItem->updateSyncStatus("to_update");

                $orderItem->save(false);
            }
        }
    }
}
