<?php

namespace emberware\vendia\arrivi\backend\controllers;

use Yii;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\WcProduct;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\vendia\groups\common\models\GroupOrder;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use emberware\vendia\groups\common\models\Order;


/**
 * OrderItemController implements the CRUD actions for OrderItem model.
 */
class OrderItemController extends Controller
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Search product
     * @return mixed
     */
    public function actionSearchProduct()
    {
        $listProduct = "";
        $wcProduct = new WcProduct();

        $request = Yii::$app->request;
        $search_key = $request->get('search');

        if($search_key){
            $listProduct = $wcProduct->findSearchedProducts($search_key);
        }
        $listProductHtml = WcProduct::listProduct($listProduct);

        return $this->render('search-product', [
            'listProductHtml' => $listProductHtml,
            'search' => $search_key,
        ]);
    }

     /**
     * Load product witch variable weight
     * @return mixed
     */
    public function actionMissingProduct($product)
    {
        $wcProduct = new WcProduct();
        $productSearched = $wcProduct->findProduct($product);

        $wcOrder = new WcOrder();
        $listOrders = $wcOrder->findOrdersMissingProduct($product);

        $html = WcProduct::htmlMissingProduct($listOrders, $productSearched);

        return $this->render('missing-product', [
            'product' => $productSearched,
            'listOrder' => $listOrders,
            'html' => $html,
        ]);
    }

     /**
     * Load product witch variable weight
     * @return mixed
     */
    public function actionVariableWeight($product)
    {
        $wcProduct = new WcProduct();
        $productSearched = $wcProduct->findProduct($product);

        $wcOrder = new WcOrder();
        $listOrders = $wcOrder->findOrdersWithProductVariableWeight($product);

        $metaDatas = $productSearched->meta_data;
        foreach($metaDatas as $metaData){
            if($metaData->key == "unita_vendita"){
                $productWeight = $metaData->value;
                $temp =  explode(" ", $productWeight);
                $productWeight = $temp[0];
            }
        }

        $html = WcProduct::htmlVariableWeight($listOrders, $productSearched);

        return $this->render('variable-weight', [
            'listOrder' => $listOrders,
            'product' => $productSearched,
            'productWeight' => $productWeight,
            'html' => $html,
        ]);
    }

     /**
     * Load product witch variable weight
     * @return mixed
     */
    public function actionDiscountCalculator()
    {
        return $this->render('discount-calculator');
    }

    /**
     * Search product
     * @return mixed
     */
    public function actionUpdateOrderVariable()
    {
        $request = Yii::$app->request->post();
        OrderItem::updateOrderItemVariableProduct($request); 

        return $this->redirect('view-updated');
    }

    public function actionViewUpdated(){
        $orderItem = new OrderItem();
        $listOrders = $orderItem->findSyncUpdatePendingAll();
        return $this->render('confirm-order', [
            'result' => true,
            'listOrders' => $listOrders,
        ]);
    }

    /**
     * Search product
     * @return mixed
     */
    public function actionUpdateOrderMissing()
    {
        $request = Yii::$app->request->post();
        OrderItem::updateOrderItemMissingProduct($request); 
        
        return $this->redirect('view-updated');
    }

    public function actionSendWoocommerce(){

        $orderItem = new OrderItem();
        $result = $orderItem->updatePendingWcOrders();

        return $this->render('confirm-send', [
            'result' => $result
        ]);

    }

    /**
     * Finds the House model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return House the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = OrderItem::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


}