$( document ).ready(function() {

    $("#show-variable").click(function(){
        $(".normal").hide();
    });
    $("#show-all").click(function(){
        $(".normal").show();
    });

    updateTotalPieces();

    checkAllBlockLineWeight();

    updateTotalRealWeight();
    updateEquivalentPieces();
    updateDiscount();

    $(".variable-pieces").on("change paste", function() {
        
        updateTotalPieces();
        checkBlockLineWeight(this);
        calculateLineWeight(this);

        updateTotalRealWeight();
        updateEquivalentPieces();
        updateDiscount();
        
    });

    $(".variable-weight").on("change paste keyup", function() {
        updateTotalRealWeight();
        updateEquivalentPieces();
        updateTotalPieces();
        updateDiscount();
    });

    //page discount calculator
    $(".single-weight").on("change paste keyup", function() {
        var singleWeight = $(this).val();
        var totalWeight = $(".total-weight").val();
        var discount = calculateDiscountPage(singleWeight, totalWeight);
        $('.discount').html(discount+"%");
    });

    $(".total-weight").on("change paste keyup", function() {
        var singleWeight = $(".single-weight").val();
        var totalWeight = $(this).val();
        var discount = calculateDiscountPage(singleWeight, totalWeight);
        $('.discount').html(discount+"%");
    });

    $(".number-pieces").on("change paste keyup", function() {
        var singleWeight = $(".single-weight").val();
        var totalWeight = $(".total-weight").val();
        var discount = calculateDiscountPage(singleWeight, totalWeight);
        $('.discount').html(discount+"%");
    });

});

function calculateDiscountPage(){
    var originalWeight = getOriginalWeight();
    var realWeight = getRealWeight();
    var discount = ((originalWeight - realWeight)/originalWeight)*100;
    return roundTo(discount, 2);
}

function getOriginalWeight(){
    var originalWeight = $("#original_weight").val();
    return originalWeight;
}

function getRealWeight(){
    var realWeight = $("#real_weight").val();
    return realWeight;
}

function getTotalRealWeight(){    
    var totWeightReal = 0;
    $(".variable-weight").each(function(){
        totWeightReal = totWeightReal + parseInt($(this).val());
    });
    return totWeightReal;
}

function updateTotalRealWeight(){    
    var totWeightReal = getTotalRealWeight();
    $('#total-weight').html(totWeightReal);
}

function getEquivalentPieces(){
    var totWeightReal = getTotalRealWeight();
    var singleWeight = getSingleWeight();
    
    var totEquivalentPieces = 0;
    totEquivalentPieces = roundTo(totWeightReal / singleWeight, 2);
    
    return totEquivalentPieces;
}

function updateEquivalentPieces(){
    var totEquivalentPieces = getEquivalentPieces();
    $('#total-equivalent-pieces').html(totEquivalentPieces);
}

function getTotalPieces(){
    var totPieces = 0;
    $(".variable-pieces").each(function(){
        totPieces = totPieces + parseInt($(this).val());
    });
    return totPieces;
}

function updateTotalPieces(){
    var totPieces = getTotalPieces();
    $('#total-pieces').html(totPieces);
}

function roundTo(value, places){
    var power = Math.pow(10, places);
    return Math.round(value * power) / power;
}

function calculateEquivalentPrice(default_pieces,equivalent_pieces){
    var defaultPrice = $("#default_price").val();
    var equivalentPrice = defaultPrice/default_pieces*equivalent_pieces;
    var discount = ((defaultPrice-equivalentPrice)/defaultPrice)*100;
    return roundTo(discount, 2);
}

function getSingleWeight(){
    var singleWeight = $("#single_weight").val();
    return singleWeight;
}

function calculateDiscount(){
    var singleWeight = getSingleWeight();
    var totalPieces = getTotalPieces();
    var originalWeight = totalPieces*singleWeight;
    var totalWeightReal = getTotalRealWeight();
    var discount = ((originalWeight - totalWeightReal)/(originalWeight))*100;
    return roundTo(discount, 2);
}

function updateDiscount(){
    var discount = calculateDiscount();
    $('#total-discount').html(discount);
}

function checkBlockLineWeight(line){
    var id = $(line).attr("id");
    var pieces = parseInt($(line).val());
    
    if(pieces == "0" || pieces == ""){
        $("#row-"+id+" .variable-weight").attr('readonly','readonly');
        $("#row-"+id+" .variable-weight").val("0");
    }
}

function checkAllBlockLineWeight(){
    $(".variable-pieces").each(function(){
        checkBlockLineWeight(this);
    });
}

function calculateLineWeight(line){

    var id = $(line).attr("id");
    var pieces = parseInt($(line).val());
    var realWeight = $("#row-"+id+" .real-weight").val();

    if(pieces > "0"){
        $("#row-"+id+" .variable-weight").removeAttr('readonly');
        $("#row-"+id+" .variable-weight").val(realWeight*pieces);
    }
}

