<?php

namespace emberware\vendia\arrivi\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcClient;
use emberware\vendia\arrivi\common\models\WcCustomer;
use emberware\vendia\arrivi\common\models\OrderItem;

class WcProduct extends WcClient
{

    /**
     * Lista di tutti i prodotti
    */
    public function findProducts($page){
        return $this->get('products?per_page=100&page='.$page.'&orderby=title&order=asc');
    }

    /**
     * Lista dei prodotto dopo la ricerca
    */
    public function findSearchedProducts($search){
        return $this->get('products?per_page=100&orderby=title&order=asc&search='.urlencode($search));
    }

    /**
     * Lista di tutti i prodotti
    */
    public function findProduct($id){
        return $this->get('products/'.$id);
    }

    public function findAllProducts(){

        $page = 1;
        $arrProducts = array();

        $products = $this->findProducts($page);

        while(!empty($products)){
            foreach($products as $product){
                array_push($arrProducts, $product);
            }
            $page++;   
            $products = $this->findProducts($page);        
        }

        return $arrProducts;
    }


    public function getQuantity($order,$idProduct){

        $quantity = 0;
        $line_items = $order->line_items;

        foreach($line_items as $item){
            
            if($item->product_id == $idProduct){
                $quantity = $item->quantity;
            }
        }

        return $quantity;
    }

    public function getTotal($order, $idProduct){
        $total = 0;
        $line_items = $order->line_items;

        foreach($line_items as $item){
            if($item->product_id == $idProduct){
                $total = $item->total;
            }
        }

        return $total;
    }

    public static function newPrice($price, $weight, $newWeight, $quantity){
        
        if($quantity != "0"){
            $newPrice = (($price / $weight) * $newWeight) / $quantity;
            return number_format($newPrice, 2, '.', '');
        }else{
            return "0";
        }
        
    }

    public static function quantityPrice($price, $quantity){
        if($quantity != "0"){
            $quantityPrice = $price * $quantity;
            return number_format($quantityPrice, 2, '.', '');
        }else{
            return "0";
        }
       
    }

    /** Funzione che crea la lista dei prodotti per modifica quantità e peso */
    public static function listProduct($listProduct){
        $html = "";
        if($listProduct){
            foreach($listProduct as $product){                
                $listMetaData = $product->meta_data;
                foreach($listMetaData as $metaData){
                    if($metaData->key == "unita_misura" && $metaData->value == "gr"){
                        $button = "<a type='button' href='variable-weight?product=$product->id' class='btn btn-primary col-lg-1 col-md-1'> <i class='fa fa-fw fa-balance-scale'></i> </a>";
                        $classVariable = "variable";
                        break;
                    }else{                        
                        $button = "<a href='missing-product?product=$product->id' type='button' class='btn btn-danger mancanti col-lg-1 col-md-1'> <i class='fa fa-fw fa-minus-circle'></i> </a>";  
                        $classVariable = "normal";              
                    }
                }                
                $html .='<div class="row '.$classVariable.'"><li class="list-group-item col-lg-8 col-md-8 col-sm-10 col-xs-10">'.$product->name.'</li>'.$button.'</div>';
            }
        }
        return $html;
    }

    public static function dataProduct(){
        $wcProduct = new WcProduct();
        $prod = $wcProduct->findProduct($product);
        $metaDatas = $prod->meta_data;
        foreach($metaDatas as $metaData){
            if($metaData->key == "unita_vendita"){
                $productWeight = $metaData->value;
            }
        }
    }

    public static function getWeight($productSearched){
        $metaDatas = $productSearched->meta_data;
        foreach($metaDatas as $metaData){
            if($metaData->key == "unita_vendita"){
                $productWeight = $metaData->value;
                $temp =  explode(" ", $productWeight);
                $productWeight = $temp[0];
            }
        }
        return $productWeight;
    }

    public static function htmlVariableWeight($listOrder, $product){
        $quantity= "";
        $productWeight = WcProduct::getWeight($product);
        $html = '<div class="list-group">
            <div class="row">';
                $totWeight = 0;
                $i = 0;
                foreach($listOrder as $order){
                    
                    $wcCustomer = new WcCustomer();
                    $customer = $wcCustomer->findCustomer($order->customer_id);
                    
                    $wcProduct = new WcProduct();
                    $productTotal = $wcProduct->getTotal($order, $product->id);  
                    $html .= '<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                        <div class="box-product">';                            
                            foreach($order->line_items as $line_item){ 
                                if($product->id == $line_item->product_id){
                                    $quantity = $line_item->quantity;

                                    $orderItem = OrderItem::loadOrderItemByItemId($line_item->id);
                                    $totWeight = $totWeight + ($productWeight*$quantity);
                                    if(empty($orderItem)){    
                                        $newWeight = $productWeight*$quantity;                                    
                                    }else{
                                        $newWeight = $orderItem->real_weight;
                                        $quantity = $orderItem->quantity;
                                    }
                                    $html .='<div class="row" id="row-'.$line_item->id.'">
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
                                            <div class="box-title-input">
                                                <h5 class="order">Ordine n. '.$order->number.' di <br>'.$customer->first_name.' '.$customer->last_name.'</h5>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
                                            <div class="box-input-quantity">
                                                <b class="title-label">Quantità:</b><input class="form-control form-input-quantity variable-pieces" id="'.$line_item->id.'" value="'.$quantity.'" type="text" name="Order['.$i.'][product-quantity]">
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4">
                                            <div class="box-input-weight">   
                                                <b class="title-label">Peso:</b><input class="form-control form-input-quantity variable-weight" value="'.$newWeight.'" type="text" name="Order['.$i.'][product-new-weight]"><b class="end-label">gr</b>                      
                                            </div>
                                        </div>
                                        <input value="'.$order->id.'" type="hidden" name="Order['.$i.'][order-id]">
                                        <input value="'.$product->id.'" type="hidden" name="Order['.$i.'][product-id]">
                                        <input value="'.$line_item->id.'" type="hidden" name="Order['.$i.'][item-id]">
                                        <input value="'.$product->name.'" type="hidden" name="Order['.$i.'][product-title]">
                                        <input value="'.$product->price.'" type="hidden" name="Order['.$i.'][product-price]">
                                        <input value="'.$productTotal.'" type="hidden" name="Order['.$i.'][product-total]">
                                        <input value="'.$productWeight.'" type="hidden" name="Order['.$i.'][product-weight]">
                                        <input value="'.$totWeight.'" type="hidden" class="tot-weight" name="tot-weight">
                                        <input value="'.$newWeight.'" type="hidden" class="real-weight" name="real-weight">
                                    </div>';  
                                    $i++;
                                    }
                                } 
                        $html .='</div>
                        </div>';
                    }       
            $html .='</div>
        </div>';

        return $html;
    }


    public static function htmlMissingProduct($listOrder, $product){
        $html ='<ul class="list-group">
            <div class="row">';   
                    $i = 0;
                    foreach($listOrder as $order){
                       
                        $wcCustomer = new WcCustomer();
                        $customer = $wcCustomer->findCustomer($order->customer_id);

                        $wcProduct = new WcProduct(); 
                        $productTotal = $wcProduct->getTotal($order, $product->id);

                    $html .='<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">                            
                    <div class="box-product">';                        
                        foreach($order->line_items as $line_item){ 
                            if($product->id == $line_item->product_id){
                                $quantity = $line_item->quantity;

                                $orderItem = OrderItem::loadOrderItemByItemId($line_item->id);
                            
                                if(empty($orderItem)){ 
                                    $newQuantity = $quantity;  
                                }else{
                                    $newQuantity = $orderItem->quantity;
                                }
                        
                        $html .='<div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4"> 
                                <div class="box-title-input">         
                                    <h5 class="order">Ordine n. '.$order->number.' di <br>'.$customer->first_name.' '.$customer->last_name.'</h5>
                                </div>
                            </div>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">   
                                <div class="box-input-quantity">                                 
                                    <b class="title-label">Quantità:</b><input class="form-control form-input-quantity variable-pieces" value="'.$newQuantity.'" type="text" name="Order['.$i.'][product-new-quantity]">                        
                                </div>
                            </div>
                        </div>
                        <input value="'.$order->id.'" type="hidden" name="Order['.$i.'][order-id]">
                        <input value="'.$product->id.'" type="hidden" name="Order['.$i.'][product-id]">
                        <input value="'.$line_item->id.'" type="hidden" name="Order['.$i.'][item-id]">
                        <input value="'.$product->price.'" type="hidden" name="Order['.$i.'][product-price]">
                        <input value="'.$product->name.'" type="hidden" name="Order['.$i.'][product-title]">
                        <input value="'.$productTotal.'" type="hidden" name="Order['.$i.'][product-total]">
                        <input value="'.$quantity.'" type="hidden" name="Order['.$i.'][product-quantity]">';
                            $i++;
                            }
                        }
                    $html .='</div>
                </div>';
                
                }      
            $html .='</div>
        </ul>';
        return $html;
    }
}
