<?php
namespace emberware\vendia\dashboard\backend\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use backend\models\LoginForm;
use emberware\vendia\arrivi\common\behaviors\SyncStatusBehaviors;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\vendia\groups\common\models\Customer;
use emberware\vendia\groups\common\models\GroupOrder;
use emberware\vendia\groups\common\models\Order;

/**
 * Site controller
 */
class DashboardController extends Controller
{
    public $defaultAction ="dashboard";
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
                // 'denyCallback' => function ($rule, $action) {
                //     throw new \Exception('Non sei autorizzato ad accedere a questa pagina!');
                // }
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionDashboard()
    {
        //numero di customer non associati
        // $NumeroCustomerDisp = Customer::findGroupAvailableCustomers();
        $order = new Order();
        $groupOrder = new GroupOrder();
        $orderItem = new OrderItem();
      return $this->render(
        'dashboard',
        [
          'numberOfUpdatePendingOrders' => $order->numberOfUpdatePending,
          'numberOfUpdatePendingGroupOrders' => $groupOrder->numberOfUpdatePending,
          'numberOfUpdatePendingOrderItems' => $orderItem->numberOfUpdatePending,
          'numberOfCreatePendingGroupOrders' => $groupOrder->numberOfCreatePending,
          'numberOfStatusInProgressGroupOrders' => $groupOrder->numberOfStatusInProgress,
          'numberOfStatusInProcessingOrders' => $order->numberOfStatusProcessing,
          'numberOfStatusInPendingOrders' => $order->numberOfStatusInPending,
          'numberOfStatusInOnHoldOrders' => $order->numberOfStatusInOnHold,
          'numberOfFreeOrder' => $order->numberOfFreeOrder,
        ]
      );
    }

}
