<?php

namespace emberware\vendia\groups\backend\controllers;

use emberware\vendia\groups\common\models\Customer;
use emberware\vendia\groups\common\models\WcCustomer;
use emberware\vendia\groups\common\models\WcOrder;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\GroupCustomer;
use Yii;
use yii\web\Controller;
use yii\base\ViewContextInterface;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Html;
use yii\data\ActiveDataProvider;

/**
 * Default controller for the `groups` module
 */
class GroupController extends Controller
{

    public $plural = 'Gruppi';
    public $singular = 'Gruppo';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new Group();

        $pageSize = 10;
        $dataProvider = new ActiveDataProvider([
            'query' => Group::find(),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);

        $columns =  [
                        ['class' => '\yii\grid\SerialColumn'],
                        ['attribute'=>'name',
                            'format'=>'raw',
                            'value' => function($data)
                            {return Html::a($data->name, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                        ],
                        'danea_id',
                        'user_admin_id',
                        [
                            'format'=>'raw',
                            'label' => 'Azioni',
                            'value' => function($data)
                            {return Html::button("<i class='fa fa-trash-o'></i>", ['class'=>'modal-delete-group button-link', 'value'=>$data->id]);}
                        ],
                        // [
                        //     'class' => '\yii\grid\ActionColumn',
                        //     'header' => 'Azioni',

                        // ]
                    ];

        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'columns' => $columns,
            'pageSize' => $pageSize,
        ]);
    }

    /**
     * Creates a new group model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionSave()
    {


            $data = Yii::$app->request->post();
            $group = $data;
            $availableCustomers = Customer::findGroupAvailableCustomers();

            if($data['group-action'] == "create"){

                $model = new Group();

                $model->danea_id = $group['Group']['danea_id'];
                $model->name = $group['Group']['name'];
                $model->user_admin_id = $group['Group']['user_admin_id'];
                $model->status = "30";
                $model->created_at = time();
                $model->updated_at = time();

            }else if($data['group-action'] == "update"){
                $model = $this->findModel($data['group-id']);

                $model->danea_id = $group['Group']['danea_id'];
                $model->name = $group['Group']['name'];
                $model->user_admin_id = $group['Group']['user_admin_id'];
                $model->status = "30";
                $model->updated_at = time();
            }else{

            }

            $result = $model->save(false);
            if($data['group-action'] == "update"){
            if($result){
                $groupCustomer = new GroupCustomer();
                $deleteCustomer = $groupCustomer->deleteValueGroupCustomer($model->id);
                foreach($group['selectedCustomers'] as $customer_id){
                    $groupCustomer = new GroupCustomer();
                    $groupCustomer->group_id = $model->id;
                    $groupCustomer->customer_id = $customer_id;
                    $groupCustomer->status = "30";
                    $groupCustomer->created_at = time();
                    $groupCustomer->updated_at = time();
                    $result = $groupCustomer->save(false);
                }
            }
        }

        if($data['group-action'] == "update"){
            return $this->redirect(['index']);
        }else{
            return $this->redirect(['update?id=' . $model['id']]);
        }
    }

    /**
     * Updates an existing group model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $listCustomerEnabled = array();


        $allCustomers = Customer::find()->all();
        $availableCustomers = Customer::findGroupAvailableCustomers();


        return $this->render('update', [
            'model' => $model,
            'availableCustomers' => $availableCustomers,
        ]);
    }
    /**
     * Creates a new Group model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Group();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }


    public function actionLoad()
    {
        if (Yii::$app->request->isAjax) {
            $data = Yii::$app->request->post();

            $id = $data['id'];
            $model = $this->findModel($id);



            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = $model;
            $response->statusCode = 200;
        }
        return $response;
    }

    /**
     * Deletes an existing group model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete()
    {
        if (Yii::$app->request->isAjax) {
            $data = Yii::$app->request->post();

            $id = $data['id'];

            $model = $this->findModel($id);


            $result = $model->delete();
        }

        if($result){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = true;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }


    // /**
    //  * Displays a single group model.
    //  * @param integer $id
    //  * @return mixed
    //  * @throws NotFoundHttpException if the model cannot be found
    //  */
    // public function actionView($id)
    // {
    //     return $this->render('view', [
    //         'model' => $this->findModel($id),
    //     ]);
    // }


    /**
     * Finds the group model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return group the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Group::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionGroupOrder(){
        $wcOrder = new WcOrder();
        $test = $wcOrder->findOrdersSingleGroupCustomer('1');

        print_r($test);
    }


    // /**
    //  * Search product
    //  * @return mixed
    //  */
    // public function actionSearchProduct()
    // {
    //     $wcCustomer = new WcCustomer();

    //     $request = Yii::$app->request;
    //     $search_key = $request->get('search');

    //     $wcCustomer = new WcCustomer();
    //     // $id = 460;
    //     if($search_key){
    //         $customer = $wcCustomer ->findCustomer($search_key);
    //     }else{
    //         $customer = "";
    //     }

    //     return $this->render('search-product', [
    //         'listProduct' => $customer,
    //         'search' => $search_key,
    //     ]);
    // }
    public function actionSelectCustomer()
    {
        $arrCustomer = array();
        $result = false;
        $request = Yii::$app->request->post();


        if(isset($request['to'])){
            $allCustomer = Customer::find()->all();
            //inserisco tutte le selezionate
                $customersSelectedTo = $request['to'];
                foreach($allCustomer as $customer){
                    $groupCustomer = new GroupCustomer();
                    $groupCustomer = $customer->findCustomerByWPId($customer->customer_wp_id);
                    if(in_array($customer->customer_wp_id, $customersSelectedTo)){
                        $customer->updated_at = time();
                    }
                    $result = $customer->save(false);
                }
            }
               $customerSelectedFrom = $request['from'];
                foreach($allCustomer as $customer){
                    $customer = new Customer();
                    $customer = $customer->findCustomerByWPId($customer->customer_wp_id);
                    if(in_array($customer->customer_wp_id, $producersSelectedFrom)){
                        $producer->updated_at = time();
                    }else{
                        $producer->updated_at = time();
                    }
                    $result = $producer->save(false);
                }


        if($result){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;

    }
}
