<?php

namespace emberware\vendia\groups\backend\controllers;

use emberware\vendia\groups\common\models\WcCustomer;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\GroupOrder;
use Yii;
use yii\web\Controller;
use yii\base\ViewContextInterface;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Html;
use yii\data\ActiveDataProvider;

/**
 * Default controller for the `groupsorder` module
 */
class GroupOrderController extends Controller
{

    public $plural = 'GruppiOrder';
    public $singular = 'GruppoOrder';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new GroupOrder();

        $pageSize = 10;
        $dataProvider = new ActiveDataProvider([
            'query' => GroupOrder::find(),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);

        $columns =  [
                        ['class' => '\yii\grid\SerialColumn'],
                        ['attribute'=>'id',
                            'format'=>'raw',
                            'value' => function($data)
                            {return Html::button($data->id, ['class'=>'update-group button-link', 'value'=>$data->id]);}
                        ],
                        'status',
                        'group_id',
                        // [
                        //     'format'=>'raw',
                        //     'label' => 'Azioni',
                        //     'value' => function($data)
                        //     {return Html::button("<i class='fa fa-trash-o'></i>", ['class'=>'modal-delete-group button-link', 'value'=>$data->id]);}
                        // ],
                        // [
                        //     'class' => '\yii\grid\ActionColumn',
                        //     'header' => 'Azioni',

                        // ]
                    ];

        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'columns' => $columns,
            'pageSize' => $pageSize,
        ]);
    }

  /**
     * Displays a single Paziente model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }



    /**
     * Finds the group model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return group the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GroupOrder::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

}
