<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
/* @var $this yii\web\View */
/* @var $searchModel backend\models\GuestSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = $this->context->plural;
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="datatable">
    <?=
        Breadcrumbs::widget(
            [
                'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
            ]
        ) ?>
        <h1><?= Html::encode($this->title) ?></h1>

        <div class="order-aggregation">
            <?= Html::button('Aggrega gli ordini', [ 'class' => 'btn btn-primary', 'id' => 'order-aggregation'])?>
        </div>

        <?= DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'group-order-table',
            //'filterModel' => $searchModel,
            'columns' => $columns,
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Italian.json"
                ]
            ]
        ]);
    ?>
</div>