<?php

use emberware\vendia\groups\common\models\Customer;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\helpers\ArrayHelper;
use mihaildev\ckeditor\CKEditor;
use kartik\select2\Select2;
use emberware\evidia\users\common\models\User;

/* @var $this yii\web\View */
/* @var $form yii\widgets\ActiveForm */
?>
<?php
    $customer = Customer::find()->all();
    $user = User::find()->all();
?>
<div class="group-form">

    <?php $form = ActiveForm::begin([

        'id' => 'group-form',
        'action' => ['save'],
        'options' => ['enctype' => 'multipart/form-data'],
        'fieldConfig' => [
            'horizontalCssClasses' => [
                'error' => '',
                'hint' => '',
            ],
        ],
    ]) ?>
    <div class="row">
        <div class="col-md-3 col-xs-12">
            <?= $form->field($model, 'name')->textInput()->label('Nome') ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'danea_id')->textInput()->label('Danea Id') ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'user_admin_id')->dropDownList(
                ArrayHelper::map($user,'id','name'),
                ['prompt' => 'Seleziona Amministratore Di Gruppo']
            )->label("Amministratore Di Gruppo")
            ?>
        </div>
    </div>

    <input id="group-action" name="group-action" type="hidden" value="create">
    <input id="group-id" name="group-id" type="hidden" value="<?=$model->id?>">

    <div class="form-group text-left">
        <br>
        <button type="submit" id="save-group" class="btn btn-primary">Salva</button>
        <?= Html::button('Annulla', ['id' => 'hide-sidebar','class' => 'btn btn-warning']) ?>
    </div>
</div>

<?php ActiveForm::end();
?>



