<?php

namespace emberware\vendia\groups\common\models;

use Yii;


/**
 * This is the model class for table "customer".
 *
 * @property int $id
 * @property int|null $customer_wp_id
 * @property string|null $username
 * @property string|null $first_name
 * @property string|null $last_name
 * @property string|null $email
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Customer extends \yii\db\ActiveRecord
{

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'customer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_wp_id'], 'integer'],
            [['username', 'first_name', 'last_name', 'email', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer_wp_id' => 'Customer Wp ID',
            'username' => 'Username',
            'first_name' => 'Nome',
            'last_name' => 'Cognome',
            'email' => 'Email',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    public function findCustomerByWPId($id){

         $customer =  Customer::find()
            ->select('*')
            ->where("customer_wp_id = '".$id."'")
            ->one();

        return $customer;
    }

    /**
     * All customer that are not associated to a group
     */
    public static function findGroupAvailableCustomers(){

        $selectedCustomers = GroupCustomer::find()->all();
        $selectedCustomersId = array();
        foreach($selectedCustomers as $selectedCustomer){
            array_push($selectedCustomersId, $selectedCustomer->customer_id);
        }
        $allCustomers = Customer::find()
            ->where(['not',["id" => $selectedCustomersId,]])
            ->all();
        return $allCustomers;
    }
    // public static function findAll(){
    //     $customers =  Customer::find()
    //                             ->orderBy(['first_name' => SORT_ASC])
    //                             ->all();

    //     return $customers;
    // }

}
