<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "group_order_item".
 *
 * @property int $id
 * @property int|null $group_id
 * @property int|null $customer_id
 * @property int|null $item_id
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class GroupOrderItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'group_order_item';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['group_id', 'customer_id', 'item_id'], 'integer'],
            [['status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'group_id' => 'Group ID',
            'customer_id' => 'Customer ID',
            'item_id' => 'Item ID',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
