<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcClient;
use emberware\vendia\groups\common\models\Group;

class WcOrder extends WcClient
{
    /**
     * Lista di tutti gli ordini
     */
    public function findAllOrders(){
        return $this->get('orders');
    }

    /**
     * Singlo ordine
     */
    public function findOrder($id){
        return $this->get('orders/'.$id);
    }

    /**
     * Lista degli ordini in processing
     */
    public function findProcessingOrders($page){
        return $this->get('orders?per_page=100&page='.$page.'&status=processing');
    }

    /**
     * Lista degli ordini in processing
     */
    public function findOrdersCustomers($customer){
        return $this->get('orders?status=processing&customer='.$customer);
    }


    /**
     * Lista degli ordini in processing di tutti i customer di un group
     */
    public function findOrdersAllCustomer(){

        $arrGroup = array();
        $groups = Group::find()->all();
        $i = 0;

        foreach($groups as $group){
            $customers = $group->customers_id;
            $arrCustomers = explode(',', $customers);

            foreach($arrCustomers as $customer){
                $ordersCustomer = $this->findOrdersCustomers($customer);

                foreach($ordersCustomer as $orderCustomer){
                    $arrGroup[$i][$customer] =  $orderCustomer->line_items;
                }
            }
            $i++;
        }

        return $arrGroup;
    }  

     /**
     * Lista degli ordini in processing di tutti i customer di un group
     */
    public function findOrdersSingleGroupCustomer($id){

        $arrGroup = array();
        $group = Group::find()
                        ->select('*')
                        ->where("id = '".$id."'")
                        ->one();
  

        $customers = $group->customers_id;
        $arrCustomers = explode(',', $customers);

        foreach($arrCustomers as $customer){
            $ordersCustomer = $this->findOrdersCustomers($customer);

            foreach($ordersCustomer as $orderCustomer){
                $arrGroup[$customer] =  $orderCustomer->line_items;
            }
        }

        return $arrGroup;
    }  
    
    /**
     * Lista degli ordini in processing di tutti i customer di un group
     */
    public function findOrdersGroups(){

        $arrGroup = array();
        $arrCustomer = array();
        $groups = Group::find()->all();
        $i = 0;

        foreach($groups as $group){
            
            $customers = $group->customers_id;
            $arrCustomers = explode(',', $customers);
            $arrCustomer = array();
            foreach($arrCustomers as $customer){
                
                $ordersCustomer = $this->findOrdersCustomers($customer);

                foreach($ordersCustomer as $orderCustomer){
                    $arrCustomer = array_merge($arrCustomer, $orderCustomer->line_items);
                }
            }
            array_push($arrGroup,$arrCustomer);
            $i++;
        }

        return $arrGroup;
    }  
