<?php

namespace emberware\vendia\groups\backend\controllers;

use emberware\vendia\groups\common\models\WcCustomer;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\groups\common\models\GroupOrder;
use emberware\vendia\groups\common\models\GroupCustomer;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\OrderItem;
use Yii;
use yii\web\Controller;
use yii\base\ViewContextInterface;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Html;
use yii\data\ActiveDataProvider;

/**
 * Default controller for the `groupsorder` module
 */
class GroupOrderController extends Controller
{

    public $plural = 'GruppiOrder';
    public $singular = 'GruppoOrder';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new GroupOrder();

        $pageSize = 10;
        $dataProvider = new ActiveDataProvider([
            'query' => GroupOrder::find(),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);

        $columns =  [
                        ['class' => '\yii\grid\SerialColumn'],
                        ['attribute'=>'id',
                            'format'=>'raw',
                            'value' => function($data)
                            {return Html::a($data->id, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                        ],
                        'group_id',
                        'status',
                    ];

        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'columns' => $columns,
            'pageSize' => $pageSize,
        ]);
    }

  /**
     * Displays a single Paziente model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $groupOrder = GroupOrder::findOne($id);
        $orderItemsGrouped = $groupOrder->getOrdersGrouped($groupOrder->group_id);

        $group = Group::findOne($groupOrder->group_id);

        $groupCustomer = new GroupCustomer();
        $customers = $groupCustomer->getCustomerByGroup($groupOrder->group_id);
       
     
        return $this->render('view', [
            'model' => $this->findModel($id),
            'orderItemsGrouped' => $orderItemsGrouped,
            'customers' => $customers,
            'nameGroup' => $group->name
        ]);
    }



    /**
     * Finds the group model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return group the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GroupOrder::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionCreateOrders(){

        //creazione ordine e order item presi da wp
        $order = new Order();
        $groupOrder = new GroupOrder();
        $groupId = 0;
        $orderWcId = 0;
        $result = $order->saveOrdersCustomers();

        if($result){
            //creazione ordine di gruppo
            $ordersCustomers = $order->getOrdersCustomersToGroup();

            foreach($ordersCustomers as $orderCustomer){
                if($groupId != $orderCustomer['group_id']){      
                    $groupId = $orderCustomer['group_id'];
                    $groupOrder = new GroupOrder();
                    $groupOrder->group_id = $groupId;
                    $groupOrder->status = 'to_send';
                    $groupOrder->updated_at = time();
                    $groupOrder->created_at = time();

                    $result = $groupOrder->save(false);
                }
            }
        }

        if($result){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionSendGroupsOrders(){

        //creazione ordine e order item presi da wp
        $groupOrder = new GroupOrder();
        $result = $groupOrder->sendGroupsOrders();
        
        if($result){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    

}
