<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\OrderItem;
use yii\db\Query;

/**
 * This is the model class for table "grouporder".
 *
 * @property int $id
 * @property int|null $group_id
 * @property int|null $group_order_wc_id
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class GroupOrder extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'group_order';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'group_id', 'group_order_wc_id'], 'integer'],
            [[ 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Group Order ID',
            'group_id' => 'Group Id',
            'group_order_wc_id' => 'group_order_wc_id',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroup()
    {
        return $this->hasOne(Group::className(), ['id' => 'id']);
    }

    public function findGroupOrderToSend($group_id){
        $groupOrder = GroupOrder::find()
                        ->select('*')
                        ->where("group_id = '".$group_id."' AND status = 'to_send'")
                        ->one();

        return $groupOrder;
    }

    /**
     * Vista degli ordini da aggregare come ordine di gruppo
     */
    public function getOrdersToGroup($group_id){

        $query = new Query;
        $query  ->select(['oi.item_id', 'oi.real_title', 'oi.default_title','oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(initial_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("o.status = 'to_group' AND gc.group_id = '".$group_id."'")
                ->groupBy(['gc.group_id', 'oi.product_id'])
                ->all();

        $command = $query->createCommand();
        $data = $command->queryAll();
       
        return $data;
    }

    /**
     * Vista degli ordini da aggregare come ordine di gruppo
     */
    public function getOrdersGrouped($group_id){

        // SELECT o.*, oi.*,gc.*, SUM(initial_total) total_price, SUM(quantity) total_quantity FROM `order` as o INNER JOIN order_item AS oi ON oi.order_id = o.order_wc_id INNER JOIN group_customer AS gc ON o.customer_id = gc.customer_id WHERE group_id = '1' GROUP BY gc.group_id, oi.product_id ORDER BY gc.customer_id
        $query = new Query;
        $query  ->select(['oi.item_id','oi.real_title', 'oi.default_title', 'oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(initial_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("gc.group_id = '".$group_id."'")
                ->groupBy(['gc.group_id', 'oi.product_id'])
                ->orderBy('gc.customer_id')
                ->all();

        $command = $query->createCommand();
        $data = $command->queryAll();
       
        return $data;
    }

    /**
     * Vista degli ordini da aggregare come ordine di gruppo
     */
    public function getOrdersGroupedByCustomer($group_id, $customer_id){

        //SELECT gc.customer_id, o.order_wc_id, oi.default_weight, oi.real_weight, oi.product_id, oi.order_id, gc.group_id, o.status, o.payment_method, o.customer_wc_id, o.customer_id, o.order_wc_id, SUM(initial_total) AS `total_price`, SUM(quantity) AS `total_quantity`, SUM(real_weight) AS `total_weight` FROM `order` `o` INNER JOIN `order_item` `oi` ON oi.order_id = o.order_wc_id INNER JOIN `group_customer` `gc` ON o.customer_id = gc.customer_id WHERE o.status = 'to_group' AND group_id = '1' GROUP BY `gc`.`group_id`, `oi`.`product_id`
        $query = new Query;
        $query  ->select(['oi.item_id','oi.real_title', 'oi.default_title','oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(initial_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("gc.group_id = '".$group_id."' AND o.customer_id = '".$customer_id."'")
                ->groupBy(['gc.group_id', 'oi.product_id'])
                ->all();

        $command = $query->createCommand();
        $data = $command->queryAll();
       
        return $data;
    }


    public function sendGroupsOrders(){

        $i = 0;
        $groupId = 0;
        $orderWcId = 0;
        $arrGrouped = array();
        $line_items = array();

        $order = new Order();
        $wcOrder = new WcOrder();

        //creazione ordine di gruppo
        $ordersCustomers = $order->getOrdersCustomersToGroup();

        foreach($ordersCustomers as $orderCustomer){
            if($groupId != $orderCustomer['group_id']){                   
                $groupId = $orderCustomer['group_id'];
                $ordersToGroup = $this->getOrdersToGroup($groupId);
                $arrGrouped[$groupId] = $ordersToGroup;
            }
        }

        foreach($arrGrouped as $key => $orderGrouped){
            $i = $key;
            foreach($orderGrouped as $orderItemGroup){

                if($orderItemGroup['order_wc_id'] != $orderWcId) {
                    $orderWcId = $orderItemGroup['order_wc_id'];
                    $orderToSend = new Order();
                    $orderSent = $orderToSend->findOrderByOrderWcId($orderWcId);

                    $orderSent->status = 'sent';
                    $orderSent->save(false);
                }

                if($orderItemGroup['real_weight'] != $orderItemGroup['default_weight']){
                    $name_product = $orderItemGroup['default_title']." - Peso reale ".$orderItemGroup['total_weight']." gr";
                }else{
                    $name_product = $orderItemGroup['real_title'];
                }

                $arrItem = [
                    'name' => "".$name_product."",
                    'product_id' => "".$orderItemGroup['product_id']."",
                    'quantity' => "".$orderItemGroup['total_quantity']."",
                    'subtotal' => "".$orderItemGroup['total_price']."",
                    'total' => "".$orderItemGroup['total_price'].""
                ];
                array_push($line_items, $arrItem);

                $orderItemId = $orderItemGroup['item_id'];
                $orderItemToSend = new OrderItem();
                $orderItemSent = $orderItemToSend->loadOrderItemByItemId($orderItemId);

                $orderItemSent->status = 'sent';
                $orderItemSent->save(false);
            }

            $array_order_group = [
                'payment_method' => 'bacs',
                'set_paid' => true,
                'customer_id' => '0',
                'status' => 'pending',
                'line_items' => $line_items,
            ];

            $orderWc = $wcOrder->createOrder($array_order_group);

            $groupOrder = new GroupOrder();
            $groupOrder = $groupOrder->findGroupOrderToSend($orderGrouped[$i]['group_id']);

            if($groupOrder){
                $groupOrder->group_id =  $orderGrouped[$i]['group_id'];
                $groupOrder->group_order_wc_id = $orderWc->id;
                $groupOrder->status = 'sent';
                $groupOrder->updated_at = time();                        
            }

            $result = $groupOrder->save(false); 
        }

        return $result;
    }

}
