<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\WcProduct;
use emberware\vendia\groups\common\models\Customer;
use yii\db\Query;

/**
 * This is the model class for table "order".
 *
 * @property int $id
 * @property int|null $order_wc_id
 * @property int|null $customer_wc_id
 * @property int|null $customer_id
 * @property int|null $payment_method
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 * 
 * @property OrderItem[] $order_item
 */
class Order extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'order';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_wc_id', 'customer_wc_id', 'customer_id', 'payment_method'], 'integer'],
            [['status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_wc_id' => 'Order Wc ID',
            'customer_wc_id' => 'Customer Wc ID',
            'customer_id' => 'Customer ID',
            'payment_method' => 'Payment Method',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    public function findOrderByOrderWcId($order_wc_id){
        $order = Order::find()
                        ->select('*')
                        ->where("order_wc_id = '".$order_wc_id."'")
                        ->one();

        return $order;
    }

    /*
    * Funzione per il salvataggio degli orders dei customers
    */
    public function saveOrdersCustomers(){

        $arrCustomers = array();
        $groups = Group::find()->all();
        $wcOrder = new WcOrder();
        $result = false;
    
        foreach($groups as $group){

            //carico i customer del gruppo
            $groupCustomer = new GroupCustomer();
            $arrCustomers = $groupCustomer->getCustomerByGroup($group->id);
    
            foreach($arrCustomers as $arrCustomer){
                
                $customer = Customer::findOne($arrCustomer);
                //carico gli ordini di ciascun customer del gruppo
                $ordersCustomer = $wcOrder->findOrdersCustomers($customer->customer_wp_id);
                if(!empty($ordersCustomer)){
                    foreach($ordersCustomer as $orderCustomer){
                   
                        //salvo l'order
                        $orderSave = $this->saveOrderCustomer($orderCustomer);
                        $result = $orderSave;
        
                        //salvo gli order item legati all'ordine
                        if($result){
                           // $line_items = $orderCustomer->line_items;
                            $orderItemSave = $this->saveOrderItemCustomer($orderCustomer);
                            $result = $orderItemSave;
                        }
                    }
                }
                
            }
        }
        
        return $result;
    }

    /*
    * Funzione per il salvataggio degli order del customer
    */
    public function saveOrderCustomer($orderPost){
     
        $order = $this->findOrderByOrderWcId($orderPost->id);

        //inserisco l'order
        if($order){
            //update
            $order->payment_method = $orderPost->payment_method;
            $order->status = 'to_group';
            $order->updated_at = time();
        }else{
            //create
            $order = new Order();
            $order->order_wc_id = $orderPost->id;
            $order->customer_wc_id = $orderPost->customer_id;
           
            $customerModel = new Customer();
            $customer = $customerModel->findCustomerByWPId($orderPost->customer_id);
            
            $order->customer_id = $customer->id;
            $order->payment_method = $orderPost->payment_method;
            $order->status = 'to_group';
            $order->created_at = time();
            $order->updated_at = time();
        }  

        $result = $order->save(false);

        return $result;
    }

    /*
    * Funzione per il salvataggio degli order item di order del customer
    */
    public function saveOrderItemCustomer($orderCustomer){

        $wcProduct = new WcProduct();
        $line_items = $orderCustomer->line_items;
        foreach($line_items as $line_item){
            $OrderItemModel = new OrderItem();
            $orderItem = $OrderItemModel->loadOrderItemByItemId($line_item->id);

            $prod = $wcProduct->findProduct($line_item->product_id);       
            $metaDatas = $prod->meta_data;
            foreach($metaDatas as $metaData){
                if($metaData->key == "unita_vendita"){
                    $productWeight = $metaData->value;
                    $temp =  explode(" ", $productWeight);
                    $productWeight = $temp[0];
                }
            }

            if($orderItem){
                $orderItem->real_price = $line_item->price;
                $orderItem->quantity = $line_item->quantity;
                $orderItem->default_weight = $productWeight;
                $orderItem->default_title = $prod->name;
                $orderItem->real_title = $line_item->name;
                if($orderItem->real_weight == ""){
                    $orderItem->real_weight = (int)$productWeight;
                }
                $orderItem->initial_total = $line_item->total;                     
                $orderItem->real_total = $line_item->total;      
                $orderItem->status = "to_group";
                $orderItem->updated_at = time();                
            }else{
                $orderItem = new OrderItem();
                $orderItem->item_id = $line_item->id;
                $orderItem->order_id = $orderCustomer->id;
                $orderItem->product_id = $line_item->product_id;
                $orderItem->default_title = $prod->name;
                $orderItem->real_title = $line_item->name;
                $orderItem->default_weight = (int)$productWeight;
                if($orderItem->real_weight == ""){
                    $orderItem->real_weight = (int)$productWeight;
                }
                $orderItem->real_price = $line_item->price;
                $orderItem->quantity = $line_item->quantity;
                $orderItem->initial_total = $line_item->total;                     
                $orderItem->real_total = $line_item->total;           
                $orderItem->status = "to_group";
                $orderItem->created_at = time();
                $orderItem->updated_at = time();
            }
            $result = $orderItem->save(false);
        }

        return $result;
    }

    public function getOrdersCustomersToGroup(){
        //SELECT * FROM `order` as o JOIN group_customer AS gc ON o.customer_wc_id = gc.customer_id where o.status = 'to_group' order by gc.group_id
        $query = new Query;
        $query  ->select('*') 
                ->from('order o')
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("o.status = 'to_group'")
                ->orderBy('gc.group_id')
                ->all();

        $command = $query->createCommand();
        $data = $command->queryAll();
       
        return $data;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrderitems()
    {
        return $this->hasMany(OrderItem::className(), ['order_id' => 'id']);
    }
    
}
