<?php

namespace emberware\vendia\groups\backend\controllers;

use Yii;
use yii\web\Controller;
use emberware\vendia\groups\common\models\WcCustomer;
use emberware\vendia\groups\common\models\WcUser;
use emberware\vendia\groups\common\models\Customer;
use emberware\evidia\options\common\models\Option;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\Html;

class CustomerController extends Controller
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $model = new Customer();

        $pageSize = 10;
        $dataProvider = new ActiveDataProvider([
            'query' => Customer::find()->orderBy('first_name'),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);


        $columns =  [
                        ['class' => '\yii\grid\SerialColumn'],
                        [

                            'attribute' => 'first_name',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->first_name);
                            }
                        ],
                        [

                            'attribute' => 'last_name',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->last_name);
                            }
                        ],
                        [

                            'attribute' => 'username',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->username);
                            }
                        ],
                        [

                            'attribute' => 'phone',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->phone);
                            }
                        ],
                    ];

        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'columns' => $columns,
            'pageSize' => $pageSize
        ]);
    }

    public function actionImportCustomers(){

        $result = false;
        $wcCustomer = new WcCustomer();
        $customer = new Customer();
       
        $wcCustomers = $wcCustomer->findAllCustomers();

        foreach($wcCustomers as $wcCustomer){
            $customer = $customer->findCustomerByWPId($wcCustomer->id);
            if(empty($customer)){
                
                $customer = new Customer();

                $customer->customer_wp_id = $wcCustomer->id;
                $customer->first_name = $wcCustomer->first_name;
                $customer->last_name = $wcCustomer->last_name;
                $customer->username = $wcCustomer->username;
                $customer->email = $wcCustomer->email;
                foreach($metaDatas as $metaData){
                    if ($metaData->key == "Phone_number"){
                        $phone = $metaData->value;
                        if($phone != ""){
                            $customer->phone = $phone;
                        }else{
                            $customer->phone = "";
                        }
                    }
                }                    
                $customer->status = Yii::$app->params['active'];
                $customer->created_at = time();
                $customer->updated_at = time();
            }else{
                $metaDatas = $wcCustomer->meta_data;
                foreach($metaDatas as $metaData){
                    if ($metaData->key == "Phone_number"){
                        $phone = $metaData->value;
                        if($phone != ""){
                            $customer->phone = $phone;
                        }else{
                            $customer->phone = "";
                        }
                    }
                }           
                $customer->first_name = $wcCustomer->first_name;
                $customer->last_name = $wcCustomer->last_name;
                $customer->username = $wcCustomer->username;
                $customer->email = $wcCustomer->email;
                $customer->email = $wcCustomer->email;
                $customer->updated_at = time();
            }

            $result = $customer->save(false);
        }

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){            
            $response->data = true;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }


}
