<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

\yii\web\YiiAsset::register($this);
/* @var $this yii\web\View */
/* @var $model backend\models\paziente */

$this->title = "Ordine del ". date('d/m/Y', $groupOrder->created_at) ." - ".$group->name;
$this->params['breadcrumbs'][] = ['label' => 'groupOrder', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$nOrders = count($customersOrderItems);


?>
<div class="group-order-view">

    <h2>Ordini del gruppo: <?=$group->name?></h2>

    <h4>Data ordine: <?=date('d/m/Y', $groupOrder->created_at)?></h4>
    <h4>Numero ordini: <?=$nOrders?></h4>
    <h4>Totale ordine: € <?=number_format($groupOrder->total,2)?></h4>
<hr>
    <h3>Ordini degli utenti: </h3>
    <?php 
        
        if(!empty($customersOrderItems)){
            foreach($customersOrderItems as $customerOrderItem){
                $totalCustomer = 0;
                if(empty($customerOrderItem["orderItems"])){
                    continue;
                }
                $customer = $customerOrderItem["customer"];
                
                $orderItemsCustomer = $customerOrderItem["orderItems"];
                $paymentMethod = $orderItemsCustomer['0']['payment_method_name'];

                
                echo "<h4>".$customer->first_name." ".$customer->last_name."</h4>";
                echo "<h5>Metodo di pagamento: ".$paymentMethod."</h5>";
                echo "<h5>Telefono: ".$customer->phone."</h5>";

                foreach($orderItemsCustomer as $orderItemCustomer){             
                    $totalCustomer = $totalCustomer + $orderItemCustomer['total_price'];
                    if($orderItemCustomer['total_weight']> 10){
                        $unita_misura = "gr";
                    }else{
                        $unita_misura = "kg";
                    }
                    if($orderItemCustomer['default_weight'] != $orderItemCustomer['real_weight']){
                        $weight = $orderItemCustomer['total_weight'];
                    }else{
                        $weight = $orderItemCustomer['total_quantity'] * $orderItemCustomer['default_weight'];
                    }
                    echo "<p>".$orderItemCustomer['total_quantity']." x ".$orderItemCustomer['default_title']." - Peso totale: ".$weight." ".$unita_misura." - euro ".number_format($orderItemCustomer['total_price'],2)."</p>";
                }
                echo "<p><b>Totale euro: ".number_format($totalCustomer, 2)."</b></p><br>";
            }
           
        }
    ?>
    <h3>Ordine di gruppo: </h3>
    <?php
        if(!empty($orderItems)){
            foreach($orderItems as $orderItem){
                
                if($orderItem['total_weight']> 10){
                    $unita_misura = "gr";
                }else{
                    $unita_misura = "kg";
                }
                if($orderItem['default_weight'] != $orderItem['real_weight']){
                    $weight = $orderItem['total_weight'];
                }else{
                    $weight = $orderItem['total_quantity'] * $orderItem['default_weight'];
                }
                echo "<p>".$orderItem['total_quantity']." x ".$orderItem['default_title']." - Peso totale: ".$weight." ".$unita_misura." - euro ".number_format($orderItem['total_price'],2)."</p>";
            }
            echo "<p><b>Totale euro: ".number_format($groupOrder->total,2)."</b></p>";
        }
    ?>
</div>
