<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\OrderItem;
use yii\db\Query;

/**
 * This is the model class for table "grouporder".
 *
 * @property int $id
 * @property int|null $group_id
 * @property int|null $group_order_wc_id
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class GroupOrder extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'group_order';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'group_id', 'group_order_wc_id'], 'integer'],
            [[ 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Group Order ID',
            'group_id' => 'Group Id',
            'group_order_wc_id' => 'group_order_wc_id',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroup()
    {
        return $this->hasOne(Group::className(), ['id' => 'group_id']);
    }

    

    // /**
    //  * Vista degli ordini da aggregare come ordine di gruppo
    //  */
    // public function getOrdersToGroup($group_id){

    //     $query = new Query;
    //     $query  ->select(['g.group_customer_wc_id','oi.item_id', 'oi.real_title', 'oi.default_title','oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method','o.payment_method_name', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(initial_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
    //             ->from('order o')
    //             ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
    //             ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
    //             ->innerJoin("group g", "g.id = gc.group_id")
    //             ->where("o.status = 'to_group' AND gc.group_id = '".$group_id."'")
    //             ->groupBy(['gc.group_id', 'oi.product_id'])
    //             ->all();

    //     $command = $query->createCommand();
    //     $data = $command->queryAll();
       
    //     return $data;
    // }

    /**
     * Vista degli ordini da aggregare come ordine di gruppo ordinati per customer
     */
    public function getOrderItems(){

        // SELECT o.*, oi.*,gc.*, SUM(initial_total) total_price, SUM(quantity) total_quantity FROM `order` as o INNER JOIN order_item AS oi ON oi.order_id = o.order_wc_id INNER JOIN group_customer AS gc ON o.customer_id = gc.customer_id WHERE group_id = '1' GROUP BY gc.group_id, oi.product_id ORDER BY gc.customer_id
        $query = new Query;
        $query  ->select(['oi.item_id','oi.real_title', 'oi.default_title', 'oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method','o.payment_method_name', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(real_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("o.group_order_id = '".$this->id."'")
                ->groupBy(['gc.group_id', 'oi.product_id'])
                ->orderBy('gc.customer_id')
                ->all();

        $command = $query->createCommand();
        $data = $command->queryAll();
       
        return $data;
    }

    /**
     * Vista degli ordini da aggregare in base al customer
     */
    public function getCustomerOrderItems($customer){

        //SELECT gc.customer_id, o.order_wc_id, oi.default_weight, oi.real_weight, oi.product_id, oi.order_id, gc.group_id, o.status, o.payment_method, o.customer_wc_id, o.customer_id, o.order_wc_id, SUM(initial_total) AS `total_price`, SUM(quantity) AS `total_quantity`, SUM(real_weight) AS `total_weight` FROM `order` `o` INNER JOIN `order_item` `oi` ON oi.order_id = o.order_wc_id INNER JOIN `group_customer` `gc` ON o.customer_id = gc.customer_id WHERE o.status = 'to_group' AND group_id = '1' GROUP BY `gc`.`group_id`, `oi`.`product_id`
        $query = new Query;
        $query  ->select(['oi.item_id','oi.real_title', 'oi.default_title','oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method', 'o.payment_method_name', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(real_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("o.group_order_id = '".$this->id."' AND o.customer_id = '".$customer->id."'")
                ->groupBy(['gc.group_id', 'oi.product_id'])
                ->all();

        $command = $query->createCommand();
        $data = $command->queryAll();
       
        return $data;
    }

    public function joinOrders(){

        foreach($this->group->customers as $customer){
            foreach($customer->freeOrders as $freeOrder){
                $freeOrder->group_order_id = $this->id;
                $freeOrder->save(false);
            }
        }
    }

    public function getTotal(){

        $query = new Query;
        $query  ->select(['SUM(real_total) total'])//, 'oi.item_id','oi.real_title', 'oi.default_title','oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method', 'o.payment_method_name', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(initial_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->where("o.group_order_id = '".$this->id."'")
                ->one();

        $command = $query->createCommand();
        $data = $command->queryAll();
       
        return $data[0]["total"];
    }

    public function getGroupOrdersToSend(){
        $groupOrder = GroupOrder::find()
                        ->select('*')
                        ->where("status = 'to_send'")
                        ->all();

        return $groupOrder;
    }

    public function sendGroupsOrders(){

        $wcOrder = new WcOrder();
        $result = false;

        $groupOrders = $this->groupOrdersToSend;

        if($groupOrders){

            foreach($groupOrders as $groupOrder){

                $group = $groupOrder->group;
                $line_items = array();
                $orderItems = $groupOrder->orderItems;            

                
                foreach($orderItems as $orderItem){

                    if($orderItem['real_weight'] != $orderItem['default_weight']){
                        $name_product = $orderItem['default_title']." - Peso reale ".$orderItem['total_weight']." gr";
                    }else{
                        $name_product = $orderItem['real_title'];
                    }

                    $item = [
                        'name' => "".$name_product."",
                        'product_id' => "".$orderItem['product_id']."",
                        'quantity' => "".$orderItem['total_quantity']."",
                        'subtotal' => "".$orderItem['total_price']."",
                        'total' => "".$orderItem['total_price']."",
                    ];
                    array_push($line_items, $item);
                }

                $dataWcGroupOrder = [
                    'payment_method' => 'bacs',
                    'payment_method_title' => 'Bonifico Bancario',
                    'customer_id' => $group->group_customer_wc_id,
                    'status' => 'pending',
                    'line_items' => $line_items,
                ];

                $orderWc = $wcOrder->createOrder($dataWcGroupOrder);
                $data = [
                    'status' => 'pending'
                ];
                $orderWc = $wcOrder->updateOrder($orderWc->id,  $data);

                if($orderWc){
                    //aggiorno ordini con sent 
                    $order = new Order();
                    $ordersSent = $order->getOrdersGroupOrderToSend($groupOrder->id);
                    foreach($ordersSent as $orderSent){
                        $orderSent->status = "sent";
                        $orderSent->save(false);
                    }

                    $groupOrder->group_order_wc_id = $orderWc->id;
                    $groupOrder->status = 'sent';
                    $groupOrder->updated_at = time();     

                    $result = $groupOrder->save(false); 
                }
            }
        }else{
            $result = "no_order";
        }
      
        return $result;
    }

}
