<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\WcProduct;
use emberware\vendia\groups\common\models\Customer;
use yii\db\Query;

/**
 * This is the model class for table "order".
 *
 * @property int $id
 * @property int|null $order_wc_id
 * @property int|null $customer_wc_id
 * @property int|null $customer_id
 * @property int|null $payment_method
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 * @property int|null $group_order_id
 * 
 * @property OrderItem[] $order_item
 */
class Order extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'order';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_wc_id', 'customer_wc_id', 'customer_id', 'payment_method', 'group_order_id'], 'integer'],
            [['status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_wc_id' => 'Order Wc ID',
            'customer_wc_id' => 'Customer Wc ID',
            'customer_id' => 'Customer ID',
            'payment_method' => 'Payment Method',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'group_order_id' => 'Group Order ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroupOrders()
    {
        return $this->hasMany(GroupOrders::className(), ['id' => 'group_order_id']);
    }

    public function getOrdersGroupOrderToSend($group_order_id){
        $orders = Order::find()
                        ->select('*')
                        ->where("status = 'to_send' AND group_order_id = '".$group_order_id."'")
                        ->all();

        return $orders;
    }

    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrderitems()
    {
        return $this->hasMany(OrderItem::className(), ['order_id' => 'id']);
    }

    public function findOrderByOrderWcId($order_wc_id){
        $order = Order::find()
                        ->select('*')
                        ->where("order_wc_id = '".$order_wc_id."'")
                        ->one();

        return $order;
    }

    /*
    * Funzione per il salvataggio degli orders dei customers
    */
    public function saveOrdersCustomers(){

        $ordersCustomer = array();
        $arrCustomers = array();
        $groups = Group::find()->all();
        $wcOrder = new WcOrder();
        $result = false;
        $wcProduct = new WcProduct();
        $wc_orders = $wcOrder->findOrdersCustomers();

        $wc_products = $wcProduct->findAllProducts();   

        if(!empty($wc_orders)){
            foreach($wc_orders as $wc_order){
            
                //salvo l'order
                $orderSave = $this->saveOrderCustomer($wc_order);
                $orderResult = $orderSave;
                    
                // $line_items = $orderCustomer->line_items;
                $line_items = $wc_order->line_items;                         
                $wc_order_id = $wc_order->id;                         
                $orderItemSave = $this->saveOrderItemCustomer($line_items, $wc_products, $wc_order_id);
                $orderItemResult = $orderItemSave;
            }
        }      

        if($orderItemResult){
            $result = true;
        }else{
            $result = false;
        }
        
        return $result;
    }

    /*
    * Funzione per il salvataggio degli order del customer
    */
    public function saveOrderCustomer($wc_order){
     
        $order = $this->findOrderByOrderWcId($wc_order->id);
        $result = false;

        //inserisco l'order
        if($order){
            //update
            $order->payment_method = $wc_order->payment_method;
            $order->payment_method_name = $wc_order->payment_method_title;
            $order->status = "to_send";
            $order->updated_at = time();

            $result = $order->save(false);

        }else{
            $customerModel = new Customer();
            $customer = $customerModel->findCustomerByWPId($wc_order->customer_id);
            
            if($customer){
                 //create
                $order = new Order();
                $order->order_wc_id = $wc_order->id;
                $order->customer_wc_id = $wc_order->customer_id;

                $order->customer_id = $customer->id;
                $order->payment_method = $wc_order->payment_method;
                $order->payment_method_name = $wc_order->payment_method_title;
                $order->status = "to_send";
                $order->created_at = time();
                $order->updated_at = time();

                $result = $order->save(false);
            }
        }  


        return $result;
    }

    /*
    * Funzione per il salvataggio degli order item di order del customer
    */
    public function saveOrderItemCustomer($line_items, $products, $id){
        $productWeight = 0;
        $nameProduct = "";
        $wcProduct = new WcProduct();
       
        foreach($line_items as $line_item){
            $OrderItemModel = new OrderItem();
            $orderItem = $OrderItemModel->loadOrderItemByItemId($line_item->id);

            if($orderItem){
                $key = array_search($line_item->product_id, array_column($products, 'id'));
                $product = $products[$key];
                $metaDatas = $product->meta_data;
                foreach($metaDatas as $metaData){
                    if($metaData->key == "unita_vendita"){
                        $productWeight = $metaData->value;
                        $temp =  explode(" ", $productWeight);
                        $productWeight = $temp[0];
                        $orderItem->default_weight = $productWeight;
                        if($orderItem->real_weight == ""){
                            $orderItem->real_weight = (int)$productWeight;
                        }
                    }
                }
                $nameProduct = $product->name;
                $orderItem->default_title = $nameProduct; 
             
                $orderItem->real_price = $line_item->price;
                $orderItem->quantity = $line_item->quantity;
                $orderItem->real_title = $line_item->name;
                
                $orderItem->initial_total = $line_item->total;                     
                $orderItem->real_total = $line_item->total;      
                $orderItem->status = "to_group";
                $orderItem->updated_at = time();                
            }else{
                
                $orderItem = new OrderItem();
                $key = array_search($line_item->product_id, array_column($products, 'id'));
                $product = $products[$key];
                $metaDatas = $product->meta_data;
                foreach($metaDatas as $metaData){
                    if($metaData->key == "unita_vendita"){
                        $productWeight = $metaData->value;
                        $temp =  explode(" ", $productWeight);
                        $productWeight = $temp[0];
                        $orderItem->default_weight = $productWeight;
                        if($orderItem->real_weight == ""){
                            $orderItem->real_weight = (int)$productWeight;
                        }
                    }
                }
                $nameProduct = $product->name;
                $orderItem->default_title = $nameProduct; 
             
                $orderItem->item_id = $line_item->id;
                $orderItem->order_id = $id;
                $orderItem->product_id = $line_item->product_id;
                $orderItem->real_title = $line_item->name;
               
                $orderItem->real_price = $line_item->price;
                $orderItem->quantity = $line_item->quantity;
                $orderItem->initial_total = $line_item->total;                     
                $orderItem->real_total = $line_item->total;           
                $orderItem->status = "to_group";
                $orderItem->created_at = time();
                $orderItem->updated_at = time();
            }
            $result = $orderItem->save(false);
        }

        return $result;
    }

    // public function getOrdersCustomersToGroup(){
    //     //SELECT * FROM `order` as o JOIN group_customer AS gc ON o.customer_wc_id = gc.customer_id where o.status = 'to_group' order by gc.group_id
    //     $query = new Query;
    //     $query  ->select('*') 
    //             ->from('order o')
    //             ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
    //             ->where("o.status = 'to_group'")
    //             ->orderBy('gc.group_id')
    //             ->all();

    //     $command = $query->createCommand();
    //     $data = $command->queryAll();
       
    //     return $data;
    // }

}
