<?php

namespace emberware\vendia\groups\backend\controllers;

use emberware\vendia\groups\common\models\WcCustomer;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\groups\common\models\WcUser;
use emberware\vendia\groups\common\models\GroupOrder;
use emberware\vendia\groups\common\models\GroupCustomer;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\vendia\groups\common\models\Customer;
use emberware\evidia\users\common\models\User;
use Yii;
use yii\web\Controller;
use yii\base\ViewContextInterface;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Html;
use yii\data\ActiveDataProvider;
use emberware\vendia\groups\common\models\GroupOrderSearch;

/**
 * Default controller for the `groupsorder` module
 */
class GroupOrderController extends Controller
{

    public $plural = 'Ordini di gruppo';
    public $singular = 'Ordine di gruppo';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['view'],
                        'allow' => true,
                        'roles' => ['viewYourOrder'],
                        'roleParams' => function() {
                            return ['groupOrder' => GroupOrder::findOne(['id' => Yii::$app->request->get('id')])];
                        },
                    ],
                    [
                        'actions' => ['view'],
                        'allow' => true,
                        'roles' => ['viewAllOrder'],
                    ],
                    [
                        'actions' => ['index','create-orders', 'import-orders', 'send-groups-orders', 'start-week', 'end-week', 'join-order', 'join-orders', 'update-order', 'update-group-orders', 'admin'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new GroupOrder();

        $query = GroupOrder::find()->orderBy('created_at DESC');

       // $searchModel = new GroupOrderSearch();
       // $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'model' => $model,
            'query' => $query,
            // 'searchModel' => $searchModel,
            // 'searchProvider' => $searchProvider,
        ]);
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionAdmin()
    {
        $model = new GroupOrder();

        $query = GroupOrder::find()->orderBy('created_at DESC');

       // $searchModel = new GroupOrderSearch();
       // $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('admin', [
            'model' => $model,
            'query' => $query,
            // 'searchModel' => $searchModel,
            // 'searchProvider' => $searchProvider,
        ]);
    }

  /**
     * Displays a single Paziente model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $customer_id = 0;
        $totalGroup = 0;
        $viewCustomer = "";
        $viewGroup = "";
        $nOrders = 0;
        $groupOrder = GroupOrder::findOne($id);

        $customersOrderItems = array();
        $orderItems = $groupOrder->orderItems;
        $group = $groupOrder->group;
        $customers = $group->customers;
        $totalGroupOrder = $groupOrder->total;

        if(!empty($customers)){

            // cusromers orders
            foreach($customers as $customer){
                $customerOrderItems = $groupOrder->getCustomerOrderItems($customer);
                if(empty($customerOrderItems)){
                    continue;
                }
                array_push($customersOrderItems, [
                    'customer' => $customer,
                    'orderItems' => $customerOrderItems,
                ]);
            }
        }


        return $this->render('view', [
            'model' => $this->findModel($id),
            'group' => $group,
            'groupOrder' => $groupOrder,
            'customersOrderItems' => $customersOrderItems,
            'orderItems' => $orderItems,
        ]);
    }



    /**
     * Finds the group model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return group the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GroupOrder::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionCreateOrders(){

        $groupOrder = new GroupOrder();
        $result = $groupOrder->createGroupOrder();

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionJoinOrder(){

        //creazione ordine e order item presi da wp
        $result = false;
        if (Yii::$app->request->isAjax) {
            $data = Yii::$app->request->post();

            $id = $data['id'];
            $groupOrder = GroupOrder::findOne($id);
            $groupOrder->joinOrders();
            $result = true;
        }

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionJoinOrders(){

        GroupOrder::joinGroupOrders();
        $result = true;

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }


    public function actionImportOrders(){

        //creazione ordine e order item presi da wp
        $order = new Order();

        $result = $order->saveOrdersCustomers();

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    /**
     * Azione pulsante chiusura settimana
     */
    public function actionSendGroupsOrders(){

        $result = GroupOrder::sendCreateGroupsOrders();

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    /**
     * Aggiornamento singolo ordine di gruppo
     */
    public function actionUpdateOrder(){

        $result = false;

        //creazione ordine e order item presi da wp
        if (Yii::$app->request->isAjax) {
            $data = Yii::$app->request->post();

            $id = $data['id'];
            $groupOrder = GroupOrder::findOne($id);
            $result = $groupOrder->updateWcOrder();

            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            if($result){
                $response->data = $result;
                $response->statusCode = 200;
            }else{
                $response->data = false;
            }

            return $response;
        }

    }

    /**
     * Aggiornamento singolo ordine di gruppo
     */
    public function actionUpdateGroupOrders(){

        GroupOrder::updatePendingWcOrders();
        $result = true;

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;

    }

    /**
     * Azione pulsante inizio settimana
     */
    public function actionStartWeek(){

        Order::setStatusOnHoldToProcessing();

        // Order::updatePendingWcOrders();

        GroupOrder::createFromGroups();

        GroupOrder::joinGroupOrders();

        return true;

    }

    /**
     * Azione pulsante chiusura settimana
     */
    public function actionEndWeek(){

        GroupOrder::setStatusInProgressToCompleted();

        // Order::updatePendingWcOrders();

        // GroupOrder::updatePendingWcOrders();

        return true;

    }

}
