<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\groups\common\models\Customer;

/**
 * This is the model class for table "group".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $danea_id
 * @property int|null $user_admin_id
 * @property int|null $group_customer_wc_id
 * @property string|null $status
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Group extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'group';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'user_admin_id ', 'group_customer_wc_id'], 'integer'],
            [['danea_id', 'name', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Group ID',
            'name' => 'Nome',
            'danea_id' => 'Danea Id',
            'group_customer_wc_id' => 'Wc Customer',
            'user_admin_id ' => 'Amministratore Di Gruppo',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroupCustomers()
    {
        return $this->hasMany(GroupCustomer::className(), ['group_id' => 'id']);
    }

    public function getCustomers()
    {
        return $this->hasMany(Customer::className(), ['id' => 'customer_id'])
            ->via('groupCustomers')->orderBy(['first_name' => SORT_ASC, 'last_name' => SORT_ASC]);
    }

    public function getGroupOrders()
    {
        return $this->hasMany(GroupOrder::className(), ['group_id' => 'id']);
    }
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_admin_id']);
    }
}

