<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\evidia\options\common\models\Option;
use yii\db\Query;
use emberware\vendia\arrivi\common\behaviors\SyncStatusBehaviors;
use emberware\vendia\arrivi\common\behaviors\StatusBehaviors;

/**
 * This is the model class for table "grouporder".
 *
 * @property int $id
 * @property int|null $group_id
 * @property int|null $group_order_wc_id
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class GroupOrder extends \yii\db\ActiveRecord
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'sync_status' => [
                'class' => SyncStatusBehaviors::className(),
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'group_order';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'group_id', 'group_order_wc_id'], 'integer'],
            [[ 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Group Order ID',
            'group_id' => 'Group Id',
            'group_order_wc_id' => 'group_order_wc_id',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroup()
    {
        return $this->hasOne(Group::className(), ['id' => 'group_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrders()
    {
        return $this->hasMany(Order::className(), ['group_order_id' => 'id']);
    }

    /**
     * Vista degli ordini da aggregare come ordine di gruppo ordinati per customer
     */
    public function getOrderItems(){

        // SELECT o.*, oi.*,gc.*, SUM(initial_total) total_price, SUM(quantity) total_quantity FROM `order` as o INNER JOIN order_item AS oi ON oi.order_id = o.order_wc_id INNER JOIN group_customer AS gc ON o.customer_id = gc.customer_id WHERE group_id = '1' GROUP BY gc.group_id, oi.product_id ORDER BY gc.customer_id
        $query = new Query;

        $query  ->select(['oi.item_id','oi.real_title', 'oi.default_title', 'oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_code','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method','o.payment_method_name', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(real_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight']) 
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("o.group_order_id = '".$this->id."'")
                ->groupBy(['gc.group_id', 'oi.product_id'])
                ->orderBy('oi.product_code')
                ->all();


        $command = $query->createCommand();
        $data = $command->queryAll();

        return $data;
    }

    /**
     * Vista degli ordini da aggregare in base al customer
     */
    public function getCustomerOrderItems($customer){

        //SELECT gc.customer_id, o.order_wc_id, oi.default_weight, oi.real_weight, oi.product_id, oi.order_id, gc.group_id, o.status, o.payment_method, o.customer_wc_id, o.customer_id, o.order_wc_id, SUM(initial_total) AS `total_price`, SUM(quantity) AS `total_quantity`, SUM(real_weight) AS `total_weight` FROM `order` `o` INNER JOIN `order_item` `oi` ON oi.order_id = o.order_wc_id INNER JOIN `group_customer` `gc` ON o.customer_id = gc.customer_id WHERE o.status = 'to_group' AND group_id = '1' GROUP BY `gc`.`group_id`, `oi`.`product_id`
        $query = new Query;
        $query  ->select(['oi.item_id','oi.real_title', 'oi.default_title','oi.order_id', 'oi.default_weight', 'oi.product_code', 'oi.real_weight', 'oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method', 'o.payment_method_name', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(real_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight'])
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->innerJoin("group_customer gc", "o.customer_id = gc.customer_id")
                ->where("o.group_order_id = '".$this->id."' AND o.customer_id = '".$customer->id."'")
                ->groupBy(['gc.group_id', 'oi.product_id'])
                ->orderBy('oi.product_code')
                ->all();


        $command = $query->createCommand();
        $data = $command->queryAll();

        return $data;
    }

    public function joinOrders(){

        foreach($this->group->customers as $customer){
            foreach($customer->freeOrders as $freeOrder){
                $freeOrder->group_order_id = $this->id;                
                $freeOrder->save(false);
                $freeOrder->groupOrder->setSyncStatus("to_update");
                $freeOrder->groupOrder->save(false);
            }
        }
    }

    public function getTotal(){

        $query = new Query;
        $query  ->select(['SUM(real_total) total'])//, 'oi.item_id','oi.real_title', 'oi.default_title','oi.order_id', 'oi.default_weight', 'oi.real_weight','oi.product_id', 'oi.order_id', 'gc.group_id', 'o.status', 'o.payment_method', 'o.payment_method_name', 'o.customer_wc_id','gc.customer_id', 'o.customer_id', 'o.order_wc_id', 'SUM(initial_total) total_price', 'SUM(quantity) total_quantity', 'SUM(real_weight) total_weight'])
                ->from('order o')
                ->innerJoin("order_item oi", "oi.order_id = o.order_wc_id")
                ->where("o.group_order_id = '".$this->id."'")
                ->one();

        $command = $query->createCommand();
        $data = $command->queryAll();

        return $data[0]["total"];
    }


    public static function getGroupOrdersInProgress(){
        //prendo ordini di gruppo con status in_progress
        $groupOrders = GroupOrder::find()->where(['status'=>'in_progress'])->all();

        return $groupOrders;
    }

    public static function createFromGroups(){

        //creazione ordine e order item presi da wp
        $groupOrder = new GroupOrder();
        $groupId = 0;

        $groups = Group::find()->all();

        foreach($groups as $group){
            $groupOrder = new GroupOrder();
            $groupOrder->group_id = $group->id;
            $groupOrder->setStatus("in_progress");
            $groupOrder->setSyncStatus("to_create");
            $groupOrder->updated_at = time();
            $groupOrder->created_at = time();

            $result = $groupOrder->save(false);
        }

        return $result;
    }

    public static function sendCreateGroupsOrders(){        
        $groupOrder = new GroupOrder();
        $groupOrders = $groupOrder->findSyncCreatePendingAll();

        foreach($groupOrders as $groupOrder){
            $groupOrder->createWcOrder();               
        }
    }

    public function createWcOrder(){
        $wcOrder = new WcOrder();
        $line_items = array();
        foreach($this->orderItems as $orderItem){
            $item = $this->formatItemForWc($orderItem);
            array_push($line_items, $item);
        }

        $dataWcGroupOrder = [
            // 'payment_method' => 'bacs',
            // 'payment_method_title' => 'Bonifico Bancario',
            'customer_id' => $this->group->group_customer_wc_id,
            'status' => $this->wcStatus,
            'line_items' => $line_items,
        ];

        $orderWc = $wcOrder->createOrder($dataWcGroupOrder);
        $dataWcGroupOrder = [
            'status' => $this->wcStatus,
        ];
        $orderWc = $wcOrder->updateOrder($orderWc->id,  $dataWcGroupOrder);

        if($orderWc){
            $this->group_order_wc_id = $orderWc->id;
            $this->setSyncStatus("synced");
            $this->save(false);
        }
    }

    public function formatItemForWc($orderItem, $wcLineItemId = NULL){

        $item = [
            'name' => "".$orderItem['default_title']." - Peso totale: ".$orderItem['total_weight']."",
            'product_id' => "".$orderItem['product_id']."",
            'quantity' => "".$orderItem['total_quantity']."",
            'subtotal' => "".$orderItem['total_price']."",
            'total' => "".$orderItem['total_price']."",
        ];

        if($wcLineItemId){
            $item["id"] = $wcLineItemId;
        }

        return $item;
    }

    public function getWcStatus(){

        switch ($this->status) {
            case 'in_progress':
                $wcStatus = "pending";
                break;
            case 'completed':
                $wcStatus = "completed";
                break;            
            default:
                $wcStatus = "pending";
                break;
        }

        return $wcStatus;
    }

    public static function updatePendingWcOrders(){

        $groupOrder = new GroupOrder();
        $groupOrders = $groupOrder->findSyncUpdatePendingAll();

        //creazione ordine e order item presi da wp
        foreach($groupOrders as $groupOrder){
            $groupOrder->updateWcOrder();
        }
    }

    public static function joinGroupOrders(){

        //per ogni ordine di gruppo con stato in_processing
        //prendere tutti gli ordini in progress e aggregarli agli ordini di gruppo
        $groupOrders = GroupOrder::find()->where(['status'=>'in_progress'])->all();

        //creazione ordine e order item presi da wp
        foreach($groupOrders as $groupOrder){
            $groupOrder->joinOrders();
        }
    }

    public static function setStatusCompleted(){
        $groupOrders = GroupOrder::find()->where(['status'=>'in_progress'])->all();

        foreach($groupOrders as $groupOrder){
            $groupOrder->setStatus("completed");
            $groupOrder->setSyncStatus("to_update");
            $groupOrder->save(false);
        }
    }

    public function getNumberOfStatusInProgress(){
        $groupOrders = GroupOrder::find()->where(['status'=>'in_progress'])->count();
        return $groupOrders;
    }

    public static function setStatusInProgressToCompleted(){

        //prendo ordini di gruppo con status in_progress
        $groupOrders = GroupOrder::find()->where(['status'=>'in_progress'])->all();
        
        foreach($groupOrders as $groupOrder){
            $groupOrder->setStatus("completed");
            $groupOrder->setSyncStatus("to_update");
            $groupOrder->save(false);

            $orders = $groupOrder->orders;
            foreach($orders as $order){
                $order->setStatus("completed");
                $order->setSyncStatus("to_update");
                $order->save(false);
            }
        }
    }


    public function updateWcOrder(){
        $result = false;
        $wcOrder = new WcOrder();
        $orderItem = new OrderItem();
        $line_items = array();

        $wcOrderCurrent = $wcOrder->findOrder($this->group_order_wc_id);
        foreach($this->orderItems as $orderItem){
            //verificare che l'orderItem esista nei lineItems di woocommerce
            $wcLineItemId = $this->getWcLineItemId($wcOrderCurrent->line_items, $orderItem['product_id']);

            $item = $this->formatItemForWc($orderItem, $wcLineItemId);            
            array_push($line_items,  $item);            
            
        }
        $dataWcGroupOrder = [
            'line_items' => $line_items,
            'status' => $this->wcStatus,
        ];

        $result = $wcOrder->updateOrder($this->group_order_wc_id, $dataWcGroupOrder);

        if($result){
            $this->setSyncStatus("synced");
            $this->save(true);
        }

        return $result;
    }

    /**
     * funzione per il cambio di stato in processing degli ordini in wc con stato on-hold
     */
    public function deleteWcOrder(){

        $wcOrder = new WcOrder();
        $wcOrder->deleteOrder($this->group_order_wc_id);
    }


    public function getWcLineItemId($wcOrderLineItems, $productId){
        foreach($wcOrderLineItems as $wcOrderLineItem){
            if($productId == $wcOrderLineItem->product_id){
               return $wcOrderLineItem->id;
            }              
        }
        return false;        
    }


    /**
     * salvo nelle opzioni lo stato della settimana
     */
    public static function setWeekStatus($status){
        $option = new Option();        
        $option = $option->findSlug('week-status');
        if(empty($option)){
            $option = new Option();
            $option->id_user_ins = Yii::$app->user->id;
            $option->id_user_upd = Yii::$app->user->id;
            $option->date_ins = time();
            $option->date_upd = time();
        }else{
            
            $option->id_user_upd = Yii::$app->user->id;
            $option->date_upd = time();
        }
        $option->status = Yii::$app->params['active'];
        $option->name = 'Stato settimana';
        $option->type = 'text';
        $option->value = $status;
        $option->slug = 'week-status';
        $option->value = $status;


        $option->save(false);
    }
}
