<?php

namespace emberware\vendia\groups\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {
        $auth = Yii::$app->authManager;
        // $auth->removeAll();
        $rule = $auth->getRule('ViewOwnOrder');
        if( empty($rule)){
        $rule = new \emberware\vendia\groups\common\models\OrderViewRule;
        $auth->add($rule);
        }

        // add the "updateOwnPost" permission and associate the rule with it.
        $viewOwnOrder = $auth->getPermission('viewYourOrder');
        if( empty($viewOwnOrder)){
            $viewOwnOrder  = $auth->createPermission('viewYourOrder');
            $viewOwnOrder->description = 'visualizza solo ordini del utente';
            $viewOwnOrder->ruleName = $rule->name;
            $auth->add($viewOwnOrder);
        };

        // add "usersView" permission
        $permissionViewGroup = $auth->getPermission('groupView');
        if( empty($permissionViewGroup)){
            $permissionViewGroup = $auth->createPermission('groupView');
            $permissionViewGroup->description = 'visualizza grouppo';
            $auth->add($permissionViewGroup);
        };
        $permissionViewOrder = $auth->getPermission('groupOrderView');
        if( empty($permissionViewOrder)){
            $permissionViewOrder = $auth->createPermission('groupOrderView');
            $permissionViewOrder->description = 'visualizza ordine gruppo';
            $auth->add($permissionViewOrder);
        };
        $permissionViewCustomer = $auth->getPermission('customerView');
        if( empty($permissionViewCustomer)){
            $permissionViewCustomer = $auth->createPermission('customerView');
            $permissionViewCustomer->description = 'visualizza Lista customer';
            $auth->add($permissionViewCustomer);
        };
        $permissionViewArrivi = $auth->getPermission('arriviView');
        if( empty($permissionViewArrivi)){
            $permissionViewArrivi = $auth->createPermission('arriviView');
            $permissionViewArrivi->description = 'visualizza vendia arrivi';
            $auth->add($permissionViewArrivi);
        };
        $permissionViewVendita = $auth->getPermission('venditaView');
        if( empty($permissionViewVendita)){
            $permissionViewVendita = $auth->createPermission('venditaView');
            $permissionViewVendita->description = 'visualizza modalità di vendita';
            $auth->add($permissionViewVendita);
        };
        $permissionViewSistema = $auth->getPermission('sistemaView');
        if( empty($permissionViewSistema)){
            $permissionViewSistema = $auth->createPermission('sistemaView');
            $permissionViewSistema->description = 'visualizza il sistema';
            $auth->add($permissionViewSistema);
        };
        // $permissionViewTest = $auth->getPermission('leftViewTest');
        // if( empty($permissionViewTest)){
        //     $permissionViewTest = $auth->createPermission('leftViewTest');
        //     $permissionViewTest->description = 'visualizza menu laterale per utente test';
        //     $auth->add($permissionViewTest);
        // };
        // $permissionViewLaura = $auth->getPermission('leftViewLaura');
        // if( empty($permissionViewLaura)){
        //     $permissionViewLaura = $auth->createPermission('leftViewLaura');
        //     $permissionViewLaura->description = 'visualizza menu laterale utente laura';
        //     $auth->add($permissionViewLaura);
        // };
        // add "usersCreate" permission
        $permissionViewGroupAll = $auth->getPermission('viewAllOrder');
        if( empty($permissionViewGroupAll)){
            $permissionViewGroupAll = $auth->createPermission('viewAllOrder');
            $permissionViewGroupAll->description = 'visualizza tutti ordini';
            $auth->add($permissionViewGroupAll);
        };

        $adminRole = $auth->getRole('admin');
        if($adminRole){
            if(!$auth->hasChild($adminRole, $permissionViewGroup)){
                $auth->addChild($adminRole, $permissionViewGroup);
            }
            if(!$auth->hasChild($adminRole, $permissionViewOrder)){
                $auth->addChild($adminRole, $permissionViewOrder);
            }
            if(!$auth->hasChild($adminRole, $permissionViewCustomer)){
                $auth->addChild($adminRole, $permissionViewCustomer);
            }
            if(!$auth->hasChild($adminRole, $permissionViewArrivi)){
                $auth->addChild($adminRole, $permissionViewArrivi);
            }
            if(!$auth->hasChild($adminRole, $permissionViewVendita)){
                $auth->addChild($adminRole, $permissionViewVendita);
            }
            if(!$auth->hasChild($adminRole, $permissionViewSistema)){
                $auth->addChild($adminRole, $permissionViewSistema);
            }
            if(!$auth->hasChild($adminRole, $permissionViewGroupAll)){
                $auth->addChild($adminRole, $permissionViewGroupAll);
            }
            if(!$auth->hasChild($adminRole, $viewOwnOrder)){
                $auth->addChild($adminRole, $viewOwnOrder);
            }
        };
        $testRole = $auth->getRole('test');
        if($testRole){
            if(!$auth->hasChild($testRole, $permissionViewGroup)){
                $auth->addChild($testRole, $permissionViewGroup);
            }
            if(!$auth->hasChild($testRole, $permissionViewOrder)){
                $auth->addChild($testRole, $permissionViewOrder);
            }
            if(!$auth->hasChild($testRole, $permissionViewCustomer)){
                $auth->addChild($testRole, $permissionViewCustomer);
            }
            if(!$auth->hasChild($testRole, $permissionViewArrivi)){
                $auth->addChild($testRole, $permissionViewArrivi);
            }
            if(!$auth->hasChild($testRole, $permissionViewVendita)){
                $auth->addChild($testRole, $permissionViewVendita);
            }
            if(!$auth->hasChild($testRole, $permissionViewSistema)){
                $auth->addChild($testRole, $permissionViewSistema);
            }
        };
        $guestRole = $auth->getRole('guest');
        if($guestRole){
            if(!$auth->hasChild($guestRole, $permissionViewOrder)){
                $auth->addChild($guestRole, $permissionViewOrder);
            }
        };
        $lauraRole = $auth->getRole('laura');
        if($lauraRole){
            if(!$auth->hasChild($lauraRole, $permissionViewGroup)){
                $auth->addChild($lauraRole, $permissionViewGroup);
            }
            if(!$auth->hasChild($lauraRole, $permissionViewOrder)){
                $auth->addChild($lauraRole, $permissionViewOrder);
            }
            if(!$auth->hasChild($lauraRole, $permissionViewCustomer)){
                $auth->addChild($lauraRole, $permissionViewCustomer);
            }
            if(!$auth->hasChild($lauraRole, $permissionViewArrivi)){
                $auth->addChild($lauraRole, $permissionViewArrivi);
            }
            if(!$auth->hasChild($lauraRole, $permissionViewVendita)){
                $auth->addChild($lauraRole, $permissionViewVendita);
            }
        };
        return ExitCode::OK;
    }

}
