<?php

use emberware\vendia\groups\common\models\Customer;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\helpers\ArrayHelper;
use mihaildev\ckeditor\CKEditor;
use kartik\select2\Select2;
use emberware\evidia\users\common\models\User;
/* @var $this yii\web\View */
/* @var $form yii\widgets\ActiveForm */
?>
<?php
    $user = User::find()->orderBy('name ASC')->all();
    $groupCustomers = $model->customers;
?>
<div class="group-form">
    <h3>Modifica <?=$this->context->singular?> <i class="fa fa-angle-right"></i> <?=$model->name?></h3>
    <hr>
    <?php $form = ActiveForm::begin([

        'id' => 'group-form',
        'action' => ['save'],
        'options' => ['enctype' => 'multipart/form-data'],
        'fieldConfig' => [
            'horizontalCssClasses' => [
                'error' => '',
                'hint' => '',
            ],
        ],
    ]) ?>
    <div class="row">
        <div class="col-md-3 col-xs-12">
            <?= $form->field($model, 'name')->textInput()->label('Nome') ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-3 col-xs-12">
            <?= $form->field($model, 'true_group')->checkbox([
                'label' => "Gruppo fittizio",
                'checked' => $trueGroup,
                'class' => 'true_group',
            ]); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'danea_id')->textInput()->label('Danea Id') ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'user_admin_id')->dropDownList(
                ArrayHelper::map($user,'id',
                function($model) {
                    return $model['name'].' '.$model['surname'];
                }),
                ['prompt' => 'Seleziona Amministratore Di Gruppo']
            )->label("Amministratore Di Gruppo")
            ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'group_customer_wc_id')->dropDownList(
                ArrayHelper::map($customers,'customer_wp_id',function($model) {
                    return $model['first_name'].' '.$model['last_name'];
                }),
                ['prompt' => "Seleziona l'utente di gruppo"]
            )->label("Utente di gruppo")
            ?>
        </div>
    </div>

    <div class="row select-customer">
        <div class="col-lg-8 col-md-6 col-sm-10 col-xs-10">
                <div class="row">
                    <div class="col-xs-5">
                        <select name="allCustomers[]" id="search" class="form-control" size="8" multiple="multiple">
                        <?php
                        // print_r($listCustomerTo);
                        foreach($availableCustomers as $customer){
                            // if(!in_array($customer->id, $groupCustomers)){
                        ?>
                            <option value="<?=$customer->id?>" ><?=$customer->first_name." ".$customer->last_name?></option>
                        <?php
                            // }
                        }
                        ?>
                        </select>
                    </div>
                    <div class="col-xs-2">
                        <button type="button" id="search_rightAll" class="btn btn-block btn-primary"><i class="glyphicon glyphicon-forward"></i></button>
                        <button type="button" id="search_rightSelected" class="btn btn-block btn-success"><i class="glyphicon glyphicon-chevron-right"></i></button>
                        <button type="button" id="search_leftSelected" class="btn btn-block btn-danger"><i class="glyphicon glyphicon-chevron-left"></i></button>
                        <button type="button" id="search_leftAll" class="btn btn-block btn-primary"><i class="glyphicon glyphicon-backward"></i></button>
                    </div>

                    <div class="col-xs-5">
                        <select name="selectedCustomers[]" id="search_to" class="form-control" size="8" multiple="multiple">
                        <?php
                        foreach($groupCustomers as $groupCustomer){
                            ?>
                            <option value="<?=$groupCustomer->id?>" ><?=$groupCustomer->first_name." ".$groupCustomer->last_name?></option>
                            <?php
                        }
                        ?>
                        </select>
                    </div>
            </div>
        </div>
    </div>

    <input id="group-action" name="group-action" type="hidden" value="update">
    <input id="group-id" name="group-id" type="hidden" value="<?=$model->id?>">

    <div class="form-group text-left">
        <br>
        <button type="submit" id="save-group" class="btn btn-primary">Salva</button>
        <?= Html::button('Annulla', ['id' => 'hide-sidebar','class' => 'btn btn-warning']) ?>
    </div>
</div>
<?php ActiveForm::end();
?>





