<?php

namespace emberware\vendia\groups\backend\controllers;

use Yii;
use yii\web\Controller;
use emberware\vendia\groups\common\models\WcCustomer;
use emberware\vendia\groups\common\models\WcUser;
use emberware\vendia\groups\common\models\Customer;
use emberware\evidia\options\common\models\Option;
use yii\data\ActiveDataProvider;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\Html;

class CustomerController extends Controller
{

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error', 'import-customers'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $model = new Customer();

        $pageSize = 10;
        $dataProvider = new ActiveDataProvider([
            'query' => Customer::find()->orderBy('first_name'),
            'pagination' => [
                'pageSize' => 10,
            ],
        ]);


        $columns =  [
                        ['class' => '\yii\grid\SerialColumn'],
                        [

                            'attribute' => 'first_name',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->first_name);
                            }
                        ],
                        [

                            'attribute' => 'last_name',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->last_name);
                            }
                        ],
                        [

                            'attribute' => 'username',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->username);
                            }
                        ],
                        [

                            'attribute' => 'phone',
                            'format'=>'raw',
                            'value' => function($data){
                                return utf8_encode ($data->phone);
                            }
                        ],
                    ];

        return $this->render('index', [
            'model' => $model,
            'dataProvider' => $dataProvider,
            'columns' => $columns,
            'pageSize' => $pageSize
        ]);
    }

    public function actionImportCustomers(){

         //importazione customer
         $customer = new Customer();

         $result = $customer->saveImportCustomers();

         $response = Yii::$app->response;
         $response->format = \yii\web\Response::FORMAT_JSON;
         if($result){
             $response->data = $result;
             $response->statusCode = 200;
         }else{
             $response->data = false;
         }

         return $response;
        }


}
