<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use yii\data\ActiveDataProvider;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'group-order-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['class' => '\yii\grid\SerialColumn'],
                ['attribute'=>'id',
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->id, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                ],
                [ 'attribute'=>'Nome gruppo',
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->group->name;}
                ],
                [ 'attribute'=>'Data ordine',
                    'format'=>'raw',
                    'value' => function($data)
                    {return date('d/m/Y', $data->created_at);}
                ],
                [ 'attribute'=>'Totale ordine',
                    'format'=>'raw',
                    'value' => function($data)
                    {return number_format($data->total, 2);}
                ],
                'status',
                
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Italian.json"
                ]
            ]
        ]);
    ?>
</div>