<?php

namespace emberware\vendia\groups\common\models;

use Yii;

/**
 * This is the model class for table "group".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $danea_id
 * @property string|null $title
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 * @property int|null $user_admin_id
 * @property int|null $group_customer_wc_id
 * @property int|null $true_group
 */
class Group extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'group';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_admin_id', 'group_customer_wc_id', 'true_group'], 'integer'],
            [['name', 'danea_id', 'title', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'danea_id' => 'Danea ID',
            'title' => 'Title',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'user_admin_id' => 'User Admin ID',
            'group_customer_wc_id' => 'Group Customer Wc ID',
            'true_group' => 'True Group',
        ];
    }
	
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroupCustomers()
    {
        return $this->hasMany(GroupCustomer::className(), ['group_id' => 'id']);
    }

    public function getCustomers()
    {
        return $this->hasMany(Customer::className(), ['id' => 'customer_id'])
            ->via('groupCustomers')->orderBy(['first_name' => SORT_ASC, 'last_name' => SORT_ASC]);
    }

    public function getGroupOrders()
    {
        return $this->hasMany(GroupOrder::className(), ['group_id' => 'id']);
    }
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_admin_id']);
    }
}

