<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\WcProduct;
/**
 * This is the model class for table "product".
 *
 * @property int $id
 * @property int|null $product_wc_id
 * @property string|null $title
 * @property string|null $selling_unit
 * @property string|null $sku
 * @property float|null $price
 * @property string|null $weight
 * @property string|null $sorting_code
 * @property int|null $producer_wc_id
 * @property string|null $selling_quantity
 */
class Product extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'product';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_wc_id', 'producer_wc_id'], 'integer'],
            [['price'], 'number'],
            [['title', 'selling_unit', 'sku', 'weight', 'sorting_code', 'selling_quantity'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'product_wc_id' => 'Product Wc ID',
            'title' => 'Title',
            'selling_unit' => 'Selling Unit',
            'sku' => 'Sku',
            'price' => 'Price',
            'weight' => 'Weight',
            'sorting_code' => 'Sorting Code',
            'producer_wc_id' => 'Producer Wc ID',
            'selling_quantity' => 'Selling Quantity',
        ];
    }

    public static function importProducts(){

        $wc_product = new WcProduct();
        $wcProducts = $wc_product->findAllProducts();

        foreach($wcProducts as $wcProduct){
            Product::updateFromWc($wcProduct);
        }
        return true;
    }

    public static function findProductByWcId($product_wc_id){
        return Product::findOne(['product_wc_id' => $product_wc_id]);
    }

    public static function updateFromWc($wcProduct){
        $product = Product::findProductByWcId($wcProduct->id);

        if(empty($product)){
            $product = new Product();
            $product->product_wc_id = $wcProduct->id;
        }
        $product->title = $wcProduct->name;
        $product->selling_unit = $wcProduct->name;
        $product->sku = $wcProduct->sku;
        $product->price = $wcProduct->price;
        
        foreach($wcProduct->meta_data as $metaData){
            switch($metaData->key){
                case "unita_vendita":
                    $product->weight = $metaData->value;     
                    $temp =  explode(" ", $product->weight);                   
                    $product->selling_quantity = $temp[0];                        
                    break;
                case "codice_ordinamento":
                    $product->sorting_code = $metaData->value; 
                    break;
                case "unita_misura":
                    $product->selling_unit = $metaData->value;
                    break;
                case "produttore":
                    $product->producer_wc_id = $metaData->value;
                    break;
                default:
                    break;
            }
        }

        $product->save();
        return $product;
    }
}
