<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\groups\common\models\GroupCustomer;

/**
 * This is the model class for table "customer".
 *
 * @property int $id
 * @property int|null $customer_wp_id
 * @property string|null $username
 * @property string|null $first_name
 * @property string|null $last_name
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class Customer extends \yii\db\ActiveRecord
{

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'customer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_wp_id'], 'integer'],
            [['username', 'first_name', 'phone', 'last_name', 'email', 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer_wp_id' => 'Customer Wp ID',
            'username' => 'Username',
            'first_name' => 'Nome',
            'last_name' => 'Cognome',
            'email' => 'Email',
            'phone' => 'Phone',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }


    /**
     * Lista ordini che non sono associati al group order
     */
    public function getFreeOrders(){

        $freeOrders = array();
        foreach($this->orders as $order){
            if($order->group_order_id == "" && $order->status = "processing"){
                array_push($freeOrders, $order);
            }
        }
        return $freeOrders;
    }


    public function findCustomerByWPId($id){

        $customer =  Customer::find()
                            ->select('*')
                            ->where("customer_wp_id = '".$id."'")
                            ->one();

        return $customer;
    }

    /**
     * All customer that are not associated to a group
     */
    public static function findGroupAvailableCustomers(){

        $selectedCustomers = GroupCustomer::find()->all();
        $selectedCustomersId = array();
        foreach($selectedCustomers as $selectedCustomer){
            array_push($selectedCustomersId, $selectedCustomer->customer_id);
        }
        $allCustomers = Customer::find()
            ->where(['not',["id" => $selectedCustomersId,]])
            ->all();
        return $allCustomers;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroupCustomer()
    {
        return $this->hasMany(GroupCustomer::className(), ['customer_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrders()
    {
        return $this->hasMany(Order::className(), ['customer_id' => 'id']);
    }

    public function saveImportCustomers(){

        $result = false;
        $wcCustomer = new WcCustomer();

        $wcCustomers = $wcCustomer->findAllCustomers();
        // $customer = $this->findCustomerByWPId($wcCustomer->id);

        foreach($wcCustomers as $wcCustomer){
            $customer = $this->findCustomerByWPId($wcCustomer->id);
            if(empty($customer)){

                $customer = new Customer();

                $customer->customer_wp_id = $wcCustomer->id;
                $customer->created_at = time();
            }
                $customer->first_name = $wcCustomer->first_name;
                $customer->last_name = $wcCustomer->last_name;
                $customer->username = $wcCustomer->username;
                $customer->email = $wcCustomer->email;
                $metaDatas = $wcCustomer->meta_data;
                foreach($metaDatas as $metaData){
                    if ($metaData->key == "Phone_number"){
                        $phone = $metaData->value;
                        if($phone != ""){
                            $customer->phone = $phone;
                        }else{
                            $customer->phone = "";
                        }
                    }
                }
                $customer->status = Yii::$app->params['active'];
                $customer->updated_at = time();

            $result = $customer->save(false);
        }

        return $result;
    }

}
