<?php

namespace emberware\vendia\groups\common\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use emberware\vendia\groups\common\models\GroupOrder;
use Yii;

/**
 * GroupOrderSearch represents the model behind the search form of `emberware\vendia\groups\common\models\GroupOrder`.
 */
class GroupOrderSearch extends GroupOrder
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'group_id', 'group_order_wc_id'], 'integer'],
            [['status', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GroupOrder::find()->orderBy('created_at DESC');

        // add conditions that should always apply here
        // SELECT * FROM vendia.group_order
        // inner JOIN vendia.group ON vendia.group_order.group_id = vendia.group.id
        // where user_admin_id = 1;


        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        // if (!$this->validate()) {
        //     // uncomment the following line if you do not want to return any records when validation fails
        //     // $query->where('0=1');
        //     return $dataProvider;
        // }
        if (!Yii::$app->user->can('viewAllOrder')) {
            $query->join('INNER JOIN','group','group_order.group_id = group.id');

            // grid filtering conditions
            $query->andFilterWhere([
                'user_admin_id' => Yii::$app->user->id,
            ]);
        }
        return $dataProvider;
    }
}
