<?php

use emberware\vendia\groups\common\models\Customer;
use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\helpers\ArrayHelper;
use mihaildev\ckeditor\CKEditor;
use kartik\select2\Select2;
use emberware\evidia\users\common\models\User;
/* @var $this yii\web\View */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="group-form">
    <h3>Seleziona il gruppo</h3>
    <?php $form = ActiveForm::begin([

        'id' => 'group-order-form',
        'action' => ['save'],
        'fieldConfig' => [
            'horizontalCssClasses' => [
                'error' => '',
                'hint' => '',
            ],
        ],
    ]) ?>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'group_id')->dropDownList(
                ArrayHelper::map($groups,'id',function($model) {
                    return $model['name'];
                }),
                ['prompt' => "Seleziona il gruppo"]
            )->label("Gruppo")
            ?>
        </div>
    </div>

    <?php
        if($model->id){
    ?>
<div class="row select-orders">
        <div class="col-lg-10 col-md-10 col-sm-10 col-xs-10">
                <div class="row">
                    <div class="col-xs-5">
                        <select name="allOrders[]" id="search_orders" class="form-control" size="8" multiple="multiple">
                        <?php
                        // print_r($listCustomerTo);
                        foreach($orders as $order){
                            // if(!in_array($customer->id, $groupCustomers)){
                        ?>
                            <option value="<?=$order->id?>" >Ordine <?=$order->order_wc_id." - ".$order->customer->first_name." ".$order->customer->last_name." ".date("d-m-Y", strtotime($order->data_order))?></option>
                        <?php
                            // }
                        }
                        ?>
                        </select>
                    </div>
                    <div class="col-xs-2">
                        <button type="button" id="search_orders_rightAll" class="btn btn-block btn-primary"><i class="glyphicon glyphicon-forward"></i></button>
                        <button type="button" id="search_orders_rightSelected" class="btn btn-block btn-success"><i class="glyphicon glyphicon-chevron-right"></i></button>
                        <button type="button" id="search_orders_leftSelected" class="btn btn-block btn-danger"><i class="glyphicon glyphicon-chevron-left"></i></button>
                        <button type="button" id="search_orders_leftAll" class="btn btn-block btn-primary"><i class="glyphicon glyphicon-backward"></i></button>
                    </div>
                    <div class="col-xs-5">
                        <select name="selectedOrders[]" id="search_orders_to" class="form-control" size="8" multiple="multiple">
                        <?php
                        foreach($groupOrders as $groupOrder){
                            ?>
                            <option value="<?=$groupOrder->id?>" >Ordine <?=$groupOrder->order_wc_id." - ".$groupOrder->customer->first_name." ".$groupOrder->customer->last_name." ".date("d-m-Y", strtotime($groupOrder->data_order))?></option>
                            <?php
                        }
                        ?>
                        </select>
                    </div>
            </div>
        </div>
    </div>
    <?php
        }
    ?>

    <input id="group-order-action" name="group-order-action" type="hidden" value="<?=(!$model->id)? "create": "update"?>">
    <input id="group-order-id" name="group-order-id" type="hidden" value="<?=$model->id?>">

    <div class="form-group text-left">
        <br>
        <button type="submit" id="save-group-order" class="btn btn-primary">Salva</button>
        <?= Html::button('Annulla', ['id' => 'hide-sidebar','class' => 'btn btn-warning']) ?>
    </div>
</div>
<?php ActiveForm::end();
?>





