<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

emberware\vendia\groups\backend\Asset::register($this);
/* @var $this yii\web\View */
/* @var $model backend\models\paziente */

$this->title = "Ordine del ". date('d/m/Y', $groupOrder->created_at) ." - ".$group->name;
$this->params['breadcrumbs'][] = ['label' => 'groupOrder', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$nOrders = count($customersOrderItems);
?>
<div class="group-order-view">
    <div class='action-box'>        
        <?php
            echo Html::a("Modifica <i class='fa fa-edit'></i>", ['update', 'id' => $model->id], ['class' => 'btn btn-warning action-button']);
            // echo Html::a("Delete <i class='fa fa-trash'></i>", ['delete', 'id' => $model->id], [
            //     'class' => 'btn btn-danger action-button',
            //     'data' => [
            //         'confirm' => 'Are you sure you want to delete this '.Yii::$app->controller->id.'?',
            //         'method' => 'post',
            //     ],
            // ]);
        ?>
        <button class="print btn btn-primary action-button" onclick="window.print()"><i class="fa fa-print"></i> Stampa</button>
    </div>

    <h2>Ordini del gruppo: <?=$group->name?></h2>

    <h4>Data ordine: <?=date('d/m/Y', $groupOrder->created_at)?></h4>
    <h4>Numero ordini: <?=$nOrders?></h4>
    <h4>Totale ordine: € <?=number_format($groupOrder->total,2)?></h4>
    <?php
        foreach($groupOrder->getTotalPaymentMetods() as $totalPaymentMethod){
    ?>
        <h5><?=$totalPaymentMethod['payment_method_name']?>: € <?=number_format($totalPaymentMethod['total_payment'], 2)?></h5>
    <?php
        }
    ?>
<hr>
    <h3>Ordini degli utenti: </h3>
    <?php

        if(!empty($customersOrderItems)){

            foreach($customersOrderItems as $customerOrderItem){
                $totalCustomer = 0;
                if(empty($customerOrderItem["orderItems"])){
                    continue;
                }
                $customer = $customerOrderItem["customer"];

                $orderItemsCustomer = $customerOrderItem["orderItems"];
                $paymentMethod = $orderItemsCustomer['0']['payment_method_name'];
                if(empty($paymentMethod)){
                    $paymentMethod = "diversi metodi di pagamento";
                }

                foreach($orderItemsCustomer as $orderItemCustomer){
                    $totalCustomer = $totalCustomer + $orderItemCustomer['total_price'];
                }

                echo "<h5 class='name'>".$customer->first_name." ".$customer->last_name." - €".number_format($totalCustomer, 2)." - ".$paymentMethod." - Tel: ".$customer->phone."</h5>";
                foreach($orderItemsCustomer as $orderItemCustomer){
                    if($orderItemCustomer['total_weight']> 10){
                        $unita_misura = "gr";
                    }else{
                        $unita_misura = "kg";
                    }
                    if($orderItemCustomer['default_weight'] != $orderItemCustomer['real_weight']){
                        $weight = $orderItemCustomer['total_weight'];
                    }else{
                        $weight = $orderItemCustomer['total_quantity'] * $orderItemCustomer['default_weight'];
                    }
                    echo "<p>".$orderItemCustomer['total_quantity']." x ".$orderItemCustomer['default_title']." - Peso totale: ".$weight." ".$unita_misura." - euro ".number_format($orderItemCustomer['total_price'],2)."</p>";
                }
                
            }

        }
    ?>
    <h3 class="group-order">Ordine di gruppo: </h3>
    <?php
        if(!empty($orderItems)){
            foreach($orderItems as $orderItem){

                if($orderItem['total_weight']> 10){
                    $unita_misura = "gr";
                }else{
                    $unita_misura = "kg";
                }
                if($orderItem['default_weight'] != $orderItem['real_weight']){
                    $weight = $orderItem['total_weight'];
                }else{
                    $weight = $orderItem['total_quantity'] * $orderItem['default_weight'];
                }
                echo "<p>".$orderItem['total_quantity']." x ".$orderItem['default_title']." - Peso totale: ".$weight." ".$unita_misura." - euro ".number_format($orderItem['total_price'],2)."</p>";
            }
            echo "<p><b>Totale euro: ".number_format($groupOrder->total,2)."</b></p>";
        }
    ?>
</div>
