<?php
use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use fedemotta\datatables\DataTables;
use emberware\vendia\groups\backend\Asset;


emberware\vendia\groups\backend\Asset::register($this);
/* @var $this yii\web\View */
/* @var $searchModel backend\models\GuestSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
$this->title = $this->context->plural;
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="group-order-index">
    <?=
    Breadcrumbs::widget(
        [
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]
    ) ?>
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (Yii::$app->user->can('viewAllOrder')) { ?>
        <div class="order-aggregation">
            <?= Html::button('Inizio settimana', [ 'class' => 'btn btn-success', 'id' => 'start-week'])?>
            <?= Html::button('Aggiungi nuovi ordini', [ 'class' => 'btn btn-primary', 'id' => 'import-join-send'])?>
            <?= Html::button('Chiusura settimana', [ 'class' => 'btn btn-danger', 'id' => 'end-week'])?>
            <?= Html::a('Crea nuovo ordine di gruppo', ['create'], ['class' => 'btn btn-primary', 'id' => 'create-group-order']) ?>
            <input value="<?=$weekStatus?>" type="hidden" name="week-status" id="week-status">
        </div>
    <?php } ?> 

    <?= $this->render('_datatable',[
            'dataProvider' => $dataProvider,
    ]) ?>
</div>






