<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\GuestSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = "Customer";
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="datatable">
    <?=
        Breadcrumbs::widget(
            [
                'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
            ]
        ) ?>
        <h1><?= Html::encode($this->title) ?></h1>

        <div class="reload-customer">
            <?= Html::button('Importa i customer', [ 'class' => 'btn btn-primary', 'id' => 'import-customer'])?>
        </div>
        <?= DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'customer-table',
            //'filterModel' => $searchModel,
            'columns' => $columns,
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Italian.json"
                ]
            ]
        ]);
    ?>
</div>