<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\WcProduct;
use emberware\vendia\groups\common\models\Customer;
use yii\db\Query;
use emberware\vendia\arrivi\common\behaviors\SyncStatusBehaviors;
use emberware\vendia\arrivi\common\behaviors\StatusBehaviors;
use emberware\evidia\options\common\models\Option;

/**
 * This is the model class for table "order".
 *
 * @property int $id
 * @property int|null $order_wc_id
 * @property int|null $customer_wc_id
 * @property int|null $customer_id
 * @property int|null $payment_method
 * @property string|null $status
 * @property string|null $sync_status
 * @property string|null $created_at
 * @property string|null $data_order
 * @property string|null $updated_at
 * @property int|null $group_order_id
 *
 * @property OrderItem[] $order_item
 */
class Order extends \yii\db\ActiveRecord
{
     /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'sync_status' => [
                'class' => SyncStatusBehaviors::className(),
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'order';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['order_wc_id', 'customer_wc_id', 'customer_id', 'payment_method', 'group_order_id'], 'integer'],
            [['status', 'created_at', 'updated_at', 'sync_status'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'order_wc_id' => 'Order Wc ID',
            'customer_wc_id' => 'Customer Wc ID',
            'customer_id' => 'Customer ID',
            'payment_method' => 'Payment Method',
            'status' => 'Status',
            'sync_status' => 'Sync Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'data_order' => 'Data Ordine',
            'group_order_id' => 'Group Order ID',
        ];
    }

    public function getOrderMaxDate(){
        $order = Order::find()->orderBy("data_order DESC")->one();

        if($order){
            $dataOrder = $order->data_order;
        }else{
            $dataOrder = "2020-01-01T00:00:00";
        }

        return $dataOrder;
    }

     /**
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasOne(Customer::className(), ['id' => 'customer_id']);
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroupOrder()
    {
        return $this->hasOne(GroupOrder::className(), ['id' => 'group_order_id']);
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrderitems()
    {
        return $this->hasMany(OrderItem::className(), ['order_id' => 'order_wc_id']);
    }

    public function findOrderByOrderWcId($order_wc_id){
        $order = Order::find()
                        ->select('*')
                        ->where("order_wc_id = '".$order_wc_id."'")
                        ->one();

        return $order;
    }


    public function getOrdersProcessing(){
        return Order::find()->where(['status'=>'processing'])->all();
    }

    /*
    * Funzione per il salvataggio degli orders dei customers
    */
    public function saveOrdersCustomers(){

        $wcOrder = new WcOrder();
        $wcProduct = new WcProduct();
        $wc_orders = $wcOrder->findOrdersCustomers();

        foreach($wc_orders as $wc_order){
            //salvo l'order
            $orderSave = $this->saveOrderCustomer($wc_order);
        }
        return true;
    }

    /*
    * Funzione per il salvataggio degli orders
    * Salvare nelle options lo stato di importazione in corso
    * Salvare nelle options la pagina che si sta importando
    */
    public function saveOrdersCustomersPaged(){

        $option = new Option();
        $page = $option->findSlug('pagination');

        $importProcessing = $option->findSlug('import-processing');
        if($importProcessing->value == "1"){
            $page->value = (int)$page->value++;
            $page->save();
        }else{
            $page->value = "1";
            $page->save();
            $importProcessing->value = "1";
            $importProcessing->save();
        }

        $wcOrder = new WcOrder();
        $wcProduct = new WcProduct();
        $ordersProcessing = $wcOrder->findProcessingOrders($page->value);
        $wc_products = $wcProduct->findAllProducts();

        while(!empty($ordersProcessing)){
            foreach($ordersProcessing as $wc_order){
                //salvo l'order
                $orderSave = $this->saveOrderCustomer($wc_order, $wc_products);
            }
        }

        if(empty($ordersProcessing)){
            $importProcessing->value = "0";
            $importProcessing->save();

            $page->value = "0";
            $page->save();
        }

        return true;
    }

     /*
    * Funzione per il salvataggio degli orders dei customers
    * FUNZIONE DEPRECATA
    */
    public function saveOrdersCustomersCron($per_page){

        // $wcOrder = new WcOrder();
        // $wcProduct = new WcProduct();
        // $wc_products = $wcProduct->findAllProducts();

        // $orderMaxDate = $this->orderMaxDate; // diminuirlo di 1 secondo
        // $orderMaxDataMinusOneSecond = date('Y-m-d\TH:i:s', strtotime($orderMaxDate.' - 1 second'));

        // $wc_orders = $wcOrder->findProcessingOrdersByDate($orderMaxDataMinusOneSecond, $per_page);

        // if(!empty($wc_orders)){
        //     foreach($wc_orders as $wc_order){
        //         $orderSave = $this->saveOrderCustomer($wc_order);
        //         $line_items = $wc_order->line_items;
        //         $wc_order_id = $wc_order->id;
        //         $orderItemSave = $this->saveOrderItemCustomer($line_items, $wc_products, $wc_order_id);
        //     }
        // }
    }


    /*
    * Funzione per il salvataggio degli order del customer
    */
    public function saveOrderCustomer($wc_order){
        $order = $this->findOrderByOrderWcId($wc_order->id);
        $result = false;

        if(in_array($wc_order->status,["cancelled", "trash"])){
            if($order){
                if(!empty($order->groupOrder)){
                    $order->groupOrder->setSyncStatus("to_update");
                }
                $order->delete();
            }
            return;
        }

        //inserisco l'order
        if(!$order){
            $customer = new Customer();
            $customerWc = $customer->findCustomerByWPId($wc_order->customer_id);

            if($customerWc){
                $order = new Order();
                $order->order_wc_id = $wc_order->id;
                $order->customer_wc_id = $wc_order->customer_id;
                $order->customer_id = $customerWc->id;
                $order->created_at = time();
            }else{
                return;
            }
        }

        $order->payment_method = $wc_order->payment_method;
        $order->payment_method_name = $wc_order->payment_method_title;
        $order->setSyncStatus("synced");
        $order->setStatus($wc_order->status);
        $order->updated_at = time();
        $order->data_order = $wc_order->date_created;

        $order->save(false);
        $order->saveWcLineItems($wc_order->line_items);

        return $result;
    }

    /*
    * Funzione per il salvataggio degli order item di order del customer
    */
    public function saveOrderItemCustomer($line_items, $products, $id){

        $productWeight = 0;

        foreach($line_items as $line_item){
            $orderItem = OrderItem::loadOrderItemByItemId($line_item->id);

            if(!$orderItem){
                $orderItem = new OrderItem();
                $orderItem->item_id = $line_item->id;
                $orderItem->order_id = $id;
                $orderItem->product_id = $line_item->product_id;

                $orderItem->setSyncStatus("synced");
                $orderItem->created_at = time();
            }

            $key = array_search($line_item->product_id, array_column($products, 'id'));
            $product = $products[$key];
            $metaDatas = $product->meta_data;
            foreach($metaDatas as $metaData){
                if($metaData->key == "unita_vendita"){
                    $productWeight = $metaData->value;
                    $temp =  explode(" ", $productWeight);
                    $productWeight = $temp[0];
                    $orderItem->default_weight = $productWeight;
                    if($orderItem->real_weight == ""){
                        $orderItem->real_weight = (int)$productWeight;
                    }
                }
                if($metaData->key == "codice_ordinamento"){
                    $orderItem->product_code = $metaData->value;
                }
            }

            $orderItem->default_title = $product->name;
            $orderItem->real_title = $line_item->name;
            $orderItem->real_price = $line_item->price;
            $orderItem->quantity = $line_item->quantity;
            $orderItem->real_title = $line_item->name;
            $orderItem->initial_total = $line_item->total;
            $orderItem->real_total = $line_item->total;
            $orderItem->setSyncStatus("synced");
            $orderItem->updated_at = time();

            $result = $orderItem->save(false);
        }

        return $result;
    }

    public function saveWcLineItems($wc_line_items){

        foreach($wc_line_items as $wc_line_item){
            $OrderItemModel = new OrderItem();
            $orderItem = $OrderItemModel->loadOrderItemByItemId($wc_line_item->id);

            if(!$orderItem){
                $orderItem = new OrderItem();
                $orderItem->item_id = $wc_line_item->id;
                $orderItem->order_id = $this->order_wc_id;
                $orderItem->product_id = $wc_line_item->product_id;
                $orderItem->created_at = (string)time();
            }

            $product = Product::findProductByWcId($wc_line_item->product_id);
            $orderItem->default_title = $product->title;
            $orderItem->real_title = $wc_line_item->name;
            $orderItem->real_price = (string)$wc_line_item->price;
            $orderItem->default_weight = $product->selling_quantity;
            if($orderItem->real_weight == ""){
                $orderItem->real_weight = (string)(int)$orderItem->default_weight;
            }
            $orderItem->product_code = $product->sorting_code;
            $orderItem->quantity = $wc_line_item->quantity;
            $orderItem->real_title = $wc_line_item->name;
            $orderItem->initial_total = $wc_line_item->total;
            $orderItem->real_total = $wc_line_item->total;
            $orderItem->setSyncStatus("synced");
            $orderItem->updated_at = (string)time();

            $orderItem->save();
        }
    }

    /**
     * funzione per il cambio di stato in processing per tutti gli ordini importati con stato on-hold
     */

    public static function setStatusOnHoldToProcessing(){

        $orders = Order::find()->where(['status'=>'on-hold'])->all();

        foreach($orders as $order){
            if($order->customer->groupCustomer){
                $order->setStatus("processing");
                $order->setSyncStatus("to_update");
                $order->save(false);
            }
        }
    }

    /**
     * funzione per il cambio di stato in processing degli ordini in wc con stato on-hold
     */
    public function updateWcOrder(){

        $wcOrder = new WcOrder();

        $data = [
            'status' => $this->status
        ];
        $wcOrder->updateOrder($this->order_wc_id, $data);

        $this->setSyncStatus("synced");
        $this->save(false);

    }

    public static function updatePendingWcOrders(){

        $order = new Order();
        $orders = $order->findSyncUpdatePendingAll();

        //creazione ordine e order item presi da wp
        foreach($orders as $order){
            $order->updateWcOrder();
        }
    }

    /**
     * funzione per il cambio di stato in completato per tutti gli ordini che sono in stato processing
     */
    public static function setStatusCompleted(){

        $orders = Order::find()->where(['status'=>'processing'])->all();

        foreach($orders as $order){
            $order->setStatus("completed");
            $order->setSyncStatus("to_update");
            $order->save(false);
        }
    }


    /**
     * funzione per il cambio di stato degli ordini in wc diversi con stato processing
     */
    public static function setWcStatusCompleted(){
        $wcOrder = new WcOrder();
        $orders = Order::find()->where(['sync_status'=>'to_update'])->all();

        foreach($orders as $order){
            $data = [
                'status' => 'completed'
            ];
            $wcOrder->updateOrder($order->order_wc_id, $data);
        }
    }
    public function getNumberOfStatusProcessing(){
        return count($this->getOrdersProcessing());
    }

    public function getNumberOfStatusInPending(){
        $orders =  Order::find()->where(['status'=>'pending'])->count();
        return $orders;
    }

    public function getNumberOfStatusInOnHold(){
        $orders =  Order::find()->where(['status'=>'on-hold'])->count();
        return $orders;
    }

    public function getFreeOrders(){
        return Order::find()->where(['group_order_id' => null])->all();
    }
    public function getNumberOfFreeOrder(){
        return count($this->getFreeOrders());
    }

}
