<?php

namespace emberware\vendia\groups\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%order}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%group_order}}`
 */
class M201203112052AddGroupOrderIdColumnToOrderTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%order}}', 'group_order_id', $this->integer()->null());

        // creates index for column `group_order_id`
        $this->createIndex(
            '{{%idx-order-group_order_id}}',
            '{{%order}}',
            'group_order_id'
        );

        // add foreign key for table `{{%group_order}}`
        $this->addForeignKey(
            '{{%fk-order-group_order_id}}',
            '{{%order}}',
            'group_order_id',
            '{{%group_order}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%group_order}}`
        $this->dropForeignKey(
            '{{%fk-order-group_order_id}}',
            '{{%order}}'
        );

        // drops index for column `group_order_id`
        $this->dropIndex(
            '{{%idx-order-group_order_id}}',
            '{{%order}}'
        );

        $this->dropColumn('{{%order}}', 'group_order_id');
    }
}
