<?php

namespace emberware\vendia\groups\backend\controllers;

use emberware\vendia\groups\common\models\WcCustomer;
use emberware\vendia\groups\common\models\Group;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\groups\common\models\WcUser;
use emberware\vendia\groups\common\models\GroupOrder;
use emberware\vendia\groups\common\models\GroupCustomer;
use emberware\vendia\arrivi\common\models\WcOrder;
use emberware\vendia\arrivi\common\models\OrderItem;
use emberware\vendia\groups\common\models\Customer;
use emberware\evidia\users\common\models\User;
use emberware\evidia\options\common\models\Option;
use Yii;
use yii\web\Controller;
use yii\base\ViewContextInterface;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use yii\helpers\Html;
use yii\data\ActiveDataProvider;
use emberware\vendia\groups\common\models\GroupOrderSearch;

/**
 * Default controller for the `groupsorder` module
 */
class GroupOrderController extends Controller
{

    public $plural = 'Ordini di gruppo';
    public $singular = 'Ordine di gruppo';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'actions' => ['view'],
                        'allow' => true,
                        'roles' => ['viewYourOrder', 'viewAllOrder'],
                        'roleParams' => function() {
                            return ['groupOrder' => GroupOrder::findOne(['id' => Yii::$app->request->get('id')])];
                        },
                    ],
                    [
                        'actions' => ['index','create','save','update','delete', 'create-orders', 'import-orders', 'send-groups-orders', 'start-week', 'end-week', 'join-order', 'join-orders', 'update-order', 'update-group-orders', 'admin', 'import-join-send', 'delete-group-orders-in-progress'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionIndex()
    {
        $model = new GroupOrder();

        $option = new Option();
        $option = $option->findSlug('week-status');

        $searchModel = new GroupOrderSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'model' => $model,
            'weekStatus' => $option->value,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionAdmin()
    {
        $model = new GroupOrder();

        $query = GroupOrder::find()->orderBy('created_at DESC');

        $option = new Option();
        $option = $option->findSlug('week-status');

       // $searchModel = new GroupOrderSearch();
       // $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('admin', [
            'model' => $model,
            'query' => $query,
            'weekStatus' => $option->value
            // 'searchModel' => $searchModel,
            // 'searchProvider' => $searchProvider,
        ]);
    }

  /**
     * Displays a single Paziente model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        // $customer_id = 0;
        // $totalGroup = 0;
        // $viewCustomer = "";
        // $viewGroup = "";
        // $nOrders = 0;
        $groupOrder = GroupOrder::findOne($id);

        $customersOrderItems = array();
        //$orderItems = $groupOrder->orderItems;
       // $group = $groupOrder->group;
        //$customers = $group->customers;
        // $totalGroupOrder = $groupOrder->total;

        //if(!empty($customers)){

            // cusromers orders
            foreach($groupOrder->customers as $customer){
                $customerOrderItems = $groupOrder->getCustomerOrderItems($customer);
                if(empty($customerOrderItems)){
                    continue;
                }
                array_push($customersOrderItems, [
                    'customer' => $customer,
                    'orderItems' => $customerOrderItems,
                ]);
            }
        //}


        return $this->render('view', [
            'model' => $this->findModel($id),
            'group' => $groupOrder->group,
            'groupOrder' => $groupOrder,
            'customersOrderItems' => $customersOrderItems,
            'orderItems' => $groupOrder->orderItems,
        ]);
    }

    /**
     * Finds the group model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return group the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GroupOrder::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionCreateOrders(){

        $groupOrder = new GroupOrder();
        $result = $groupOrder->createGroupOrder();

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionJoinOrder(){

        //creazione ordine e order item presi da wp
        $result = false;
        if (Yii::$app->request->isAjax) {
            $data = Yii::$app->request->post();

            $id = $data['id'];
            $groupOrder = GroupOrder::findOne($id);
            $groupOrder->joinOrders();
            $result = true;
        }

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionJoinOrders(){

        GroupOrder::joinGroupOrders();
        $result = true;

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }


    public function actionImportOrders(){

        //creazione ordine e order item presi da wp
        $order = new Order();

        $result = $order->saveOrdersCustomers();

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    /**
     * Azione pulsante chiusura settimana
     */
    public function actionSendGroupsOrders(){

        $result = GroupOrder::sendCreateGroupsOrders();

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    /**
     * Aggiornamento singolo ordine di gruppo
     */
    public function actionUpdateOrder(){

        $result = false;

        //creazione ordine e order item presi da wp
        if (Yii::$app->request->isAjax) {
            $data = Yii::$app->request->post();

            $id = $data['id'];
            $groupOrder = GroupOrder::findOne($id);
            $result = $groupOrder->updateWcOrder();

            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            if($result){
                $response->data = $result;
                $response->statusCode = 200;
            }else{
                $response->data = false;
            }

            return $response;
        }

    }

    /**
     * Aggiornamento singolo ordine di gruppo
     */
    public function actionUpdateGroupOrders(){

        GroupOrder::updatePendingWcOrders();
        $result = true;

        $response = Yii::$app->response;
        $response->format = \yii\web\Response::FORMAT_JSON;
        if($result){
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;

    }

    /**
     * Azione pulsante inizio settimana
     */
    public function actionStartWeek(){

        Order::setStatusOnHoldToProcessing();

        GroupOrder::setWeekStatus('start');

        // Order::updatePendingWcOrders();

        GroupOrder::createFromGroups();

        GroupOrder::joinGroupOrders();

        GroupOrder::sendCreateGroupsOrders();

        return true;

    }

    /**
     * Azione pulsante chiusura settimana
     */
    public function actionEndWeek(){

        GroupOrder::setStatusInProgressToCompleted();

        GroupOrder::setWeekStatus('end');

        // Order::updatePendingWcOrders();

        // GroupOrder::updatePendingWcOrders();

        return true;

    }


    public function actionImportJoinSend(){

        $order = new Order();
        $order->saveOrdersCustomers();

        GroupOrder::joinGroupOrders();

        GroupOrder::updatePendingWcOrders();

        return true;
    }

    /**
     * Cancellazione ordini di gruppo in stato in_progress
     */
    public function actionDeleteGroupOrdersInProgress(){

        //prendere ordini con stato in progress,
        $groupOrdersInProgress = GroupOrder::getGroupOrdersInProgress();

        foreach($groupOrdersInProgress as $groupOrderInProgress){
            $orders = $groupOrderInProgress->orders;

            foreach($orders as $order){
                $order->group_order_id = "";
                $order->save(false);
            }

            //eliminare ordine di gruppo
            $groupOrderInProgress->deleteWcOrder();
            $groupOrderInProgress->delete();

        }
        GroupOrder::setWeekStatus('end');

        return true;
    }

    // public function actionDelete($id){

    //     $groupOrder = GroupOrder::findOne($id);
    //     $orders = $groupOrder->orders;

    //     foreach($orders as $order){
    //         $order->group_order_id = "";
    //         if(!$groupOrder->group->true_group){
    //             $order->setStatus("on-hold");
    //             $order->setSyncStatus("to_update");
    //         }
    //         $order->updated_at = time();
    //         $order->save(false);
    //     }

    //     //eliminare ordine di gruppo
    //     //$groupOrder->deleteWcOrder();
    //     $groupOrder->delete();

    //     return $this->redirect(['index']);
    // }

    /**
     * Creazione ordine di gruppo vuoto
     */
    public function actionCreate(){

        $model = new GroupOrder();
        $groups = Group::find()->all();

        return $this->render('create', [
            'model' => $model,
            'groups' => $groups,
        ]);
    }

    /**
     * Creates a new group model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionSave()
    {
        $groupOrder = Yii::$app->request->post();

        if($groupOrder['group-order-action'] == "create"){
            $model = new GroupOrder();
            $model->group_id = $groupOrder['GroupOrder']['group_id'];
            $model->setStatus("in_progress");
            $model->setSyncStatus("to_create");
            $model->updated_at = time();
            $model->created_at = time();
            $model->save(false);
        }else if($groupOrder['group-order-action'] == "update"){
            $model = GroupOrder::findOne($groupOrder['group-order-id']);
            $model->group_id = $groupOrder['GroupOrder']['group_id'];
            $model->updated_at = time();
            $model->save(false);

            if(!empty($groupOrder['selectedOrders'])){
                foreach($groupOrder['selectedOrders'] as $orderId){
                    $order = Order::findOne($orderId);
                    $order->group_order_id = $model->id;
                    $order->setStatus("processing");
                    $order->setSyncStatus("to_update");
                    $order->updated_at = time();
                    $order->save(false);

                    // $groupCustomer = new GroupCustomer();
                    // $groupCustomer->group_id = $groupOrder['GroupOrder']['group_id'];
                    // $groupCustomer->customer_id = $order->customer_id;
                    // $groupCustomer->status = "30";
                    // $groupCustomer->created_at = time();
                    // $groupCustomer->updated_at = time();
                    // $result = $groupCustomer->save(false);
                }
            }
            if(!empty($groupOrder['allOrders'])){
                foreach($groupOrder['allOrders'] as $orderId){
                    $order = Order::findOne($orderId);
                    $order->group_order_id = NULL;
                    $order->setStatus("on-hold");
                    $order->setSyncStatus("to_update");
                    $order->updated_at = time();
                    $order->save(false);

                    // $groupCustomer = GroupCustomer::find()->where(["customer_id" => $order->customer->id, "group_id" => $groupOrder['GroupOrder']['group_id']])->one();
                    // $groupCustomer->delete();

                }
            }
            
        }else{

        }

        return $this->redirect(['update', 'id' => $model->id]);
    }

    /**
     * Creazione ordine di gruppo vuoto
     */
    public function actionUpdate($id){

        $model = $this->findModel($id);
        $groups = Group::find()->all();
        $orders = Order::find()->where(['group_order_id' => NULL, 'status' => 'on-hold'])->all();
        $groupOrders = $model->orders;
         
        return $this->render('update', [
            'model' => $model,
            'groups' => $groups,
            'orders' => $orders,
            'groupOrders' => $groupOrders,
        ]);
    }

}
