<?php

namespace emberware\vendia\groups\common\models;

use Yii;
use emberware\vendia\groups\common\models\Customer;
use emberware\vendia\groups\common\models\Order;
use emberware\vendia\groups\common\models\Group;

/**
 * This is the model class for table "group_customer".
 *
 * @property int $id
 * @property int|null $group_id
 * @property int|null $customer_id
 * @property string|null $status
 * @property string|null $created_at
 * @property string|null $updated_at
*/

class GroupCustomer extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'group_customer';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'group_id', 'customer_id'], 'integer'],
            [[ 'status', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'group_id' => 'Group ID',
            'customer_id' => 'Customer Id',
            'status' => 'Status',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }


    public function getCustomerByGroup($group_id){

        $arrCustomers = array();
        $customers =  GroupCustomer::find()
                        ->select('*')
                        ->where("group_id = '".$group_id."'")
                        ->all();

        foreach($customers as $customer){
            array_push($arrCustomers, $customer->customer_id);
        }

        return $arrCustomers;
    }

     /**
     * @return \yii\db\ActiveQuery
     */
    public function getCustomer()
    {
        return $this->hasMany(Customer::className(), ['customer_id' => 'id']);
    }

     /**
     * @return \yii\db\ActiveQuery
     */
    public function getOrders()
    {
        return $this->hasMany(Order::className(), ['customer_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGroup()
    {
        return $this->hasMany(Group::className(), ['id' => 'group_id']);
    }

    public function deleteValueGroupCustomer($group_id){
        $groupCustomer = GroupCustomer::deleteAll('group_id ='. $group_id);
        return $groupCustomer;
    }

}
